/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.mcs.V18;

import com.contrastsecurity.cassandra.migration.api.JavaMigration;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import migrations.common.TableCopier;
import migrations.service.mcs.V18.jobs.DataCopier;

public class V18_1__copy_data_from_replica
implements JavaMigration {
    private static final Log LOG = LogFactory.getLog(V18_1__copy_data_from_replica.class);
    public static final int THREADS = 25;
    private PreparedStatement selectDistinctPartitionKeysStatement;

    private void initStatements(Session session) {
        this.selectDistinctPartitionKeysStatement = session.prepare("SELECT DISTINCT provider_id,dataset_id FROM latest_provider_dataset_rep_rev_replica");
        this.selectDistinctPartitionKeysStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
    }

    public void migrate(Session session) {
        ExecutorService executorService = Executors.newFixedThreadPool(25);
        try {
            this.initStatements(session);
            ResultSet distinctPartitions = session.execute((Statement)this.selectDistinctPartitionKeysStatement.bind());
            Iterator distinctPartitionIterator = distinctPartitions.iterator();
            while (TableCopier.hasNextRow(distinctPartitionIterator)) {
                Row disRow = (Row)distinctPartitionIterator.next();
                LOG.info("Submitting task for: " + disRow.getString("provider_id") + ":" + disRow.getString("dataset_id"));
                DataCopier dataCopier = new DataCopier(session, disRow.getString("provider_id"), disRow.getString("dataset_id"));
                executorService.submit(dataCopier);
            }
        }
        catch (Exception e) {
            LOG.error("The migration was not completed successfully:" + e.getMessage() + ". Because of:" + e.getCause() + " .Please clean and restart again!!");
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(100L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOG.error("The migration was not completed successfully:" + e.getMessage() + ". Because of :" + e + ". Please clean and restart again!!");
            Thread.currentThread().interrupt();
        }
    }
}

