/*
 * Decompiled with CFR 0.152.
 */
package migrator;

import java.util.Arrays;
import java.util.List;
import migrator.CliOptions;
import migrator.MigrationExecutor;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    public static final Logger log = LoggerFactory.getLogger(Migrator.class);
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String KEY_SPACE = "keySpace";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String SERVICE = "service";
    private static final List<String> SERVICES = Arrays.asList("UIS", "MCS", "DPS", "AAS");
    private static final String MIGRATIONS_DIR_PREFIX = "migrations/service/";

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        CliOptions options = Migrator.initOptions();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options.getOptions(), args);
        }
        catch (ParseException exp) {
            log.error("Reason: " + exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Migrator ", options.getOptions());
            System.exit(1);
        }
        String host = cmd.getOptionValue(HOST);
        String port = cmd.getOptionValue(PORT);
        String keySpace = cmd.getOptionValue(KEY_SPACE);
        String user = cmd.getOptionValue(USER);
        String password = cmd.getOptionValue(PASSWORD);
        String service = cmd.getOptionValue(SERVICE);
        Object chosenMigrationDir = "";
        if (SERVICES.contains(service)) {
            chosenMigrationDir = MIGRATIONS_DIR_PREFIX + service.toLowerCase();
        } else {
            log.error("Reason: " + service + " not valid service");
            System.exit(1);
        }
        if (!Migrator.serviceMatchesKeySpace(service, keySpace)) {
            log.error("Service name: " + service + " does not match keySpace name: " + keySpace);
            System.exit(1);
        }
        MigrationExecutor executor = new MigrationExecutor(keySpace, host, Integer.parseInt(port), user, password, new String[]{chosenMigrationDir});
        executor.migrate();
    }

    private static CliOptions initOptions() {
        CliOptions options = new CliOptions();
        options.addCliSetRequiredOption(HOST, "cassandra host");
        options.addCliSetRequiredOption(PORT, "cassandra port");
        options.addCliSetRequiredOption(KEY_SPACE, KEY_SPACE);
        options.addCliSetRequiredOption(USER, USER);
        options.addCliSetRequiredOption(PASSWORD, PASSWORD);
        options.addCliSetRequiredOption(SERVICE, "migrate service eg. (UIS, MCS, DPS, AAS)");
        return options;
    }

    private static boolean serviceMatchesKeySpace(String service, String keySpace) {
        return keySpace.toLowerCase().contains(service.toLowerCase());
    }
}

