/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurerUtils;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.util.Assert;

public final class ImplicitGrantConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<ImplicitGrantConfigurer<B>, B> {
    private String authorizationRequestBaseUri;

    public ImplicitGrantConfigurer<B> authorizationRequestBaseUri(String authorizationRequestBaseUri) {
        Assert.hasText(authorizationRequestBaseUri, "authorizationRequestBaseUri cannot be empty");
        this.authorizationRequestBaseUri = authorizationRequestBaseUri;
        return this;
    }

    public ImplicitGrantConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    @Override
    public void configure(B http) {
        OAuth2AuthorizationRequestRedirectFilter authorizationRequestFilter = new OAuth2AuthorizationRequestRedirectFilter(OAuth2ClientConfigurerUtils.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()), this.getAuthorizationRequestBaseUri());
        http.addFilter((Filter)this.postProcess(authorizationRequestFilter));
    }

    private String getAuthorizationRequestBaseUri() {
        return this.authorizationRequestBaseUri != null ? this.authorizationRequestBaseUri : "/oauth2/authorization";
    }
}

