/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

@Configuration(proxyBeanMethods=false)
class SecurityReactorContextConfiguration {
    SecurityReactorContextConfiguration() {
    }

    @Bean
    SecurityReactorContextSubscriberRegistrar securityReactorContextSubscriberRegistrar() {
        return new SecurityReactorContextSubscriberRegistrar();
    }

    static class SecurityReactorContextSubscriber<T>
    implements CoreSubscriber<T> {
        static final String SECURITY_CONTEXT_ATTRIBUTES = "org.springframework.security.SECURITY_CONTEXT_ATTRIBUTES";
        private final CoreSubscriber<T> delegate;
        private final Context context;

        SecurityReactorContextSubscriber(CoreSubscriber<T> delegate, Map<Object, Object> attributes) {
            this.delegate = delegate;
            Context currentContext = this.delegate.currentContext();
            Context context = currentContext.hasKey((Object)SECURITY_CONTEXT_ATTRIBUTES) ? currentContext : currentContext.put((Object)SECURITY_CONTEXT_ATTRIBUTES, attributes);
            this.context = context;
        }

        public Context currentContext() {
            return this.context;
        }

        public void onSubscribe(Subscription s2) {
            this.delegate.onSubscribe(s2);
        }

        public void onNext(T t) {
            this.delegate.onNext(t);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
        }

        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    static class SecurityReactorContextSubscriberRegistrar
    implements InitializingBean,
    DisposableBean {
        private static final String SECURITY_REACTOR_CONTEXT_OPERATOR_KEY = "org.springframework.security.SECURITY_REACTOR_CONTEXT_OPERATOR";

        SecurityReactorContextSubscriberRegistrar() {
        }

        @Override
        public void afterPropertiesSet() throws Exception {
            Function lifter = Operators.liftPublisher((pub, sub) -> this.createSubscriberIfNecessary((CoreSubscriber)sub));
            Hooks.onLastOperator((String)SECURITY_REACTOR_CONTEXT_OPERATOR_KEY, pub -> {
                if (!SecurityReactorContextSubscriberRegistrar.contextAttributesAvailable()) {
                    return pub;
                }
                return (Publisher)lifter.apply(pub);
            });
        }

        @Override
        public void destroy() throws Exception {
            Hooks.resetOnLastOperator((String)SECURITY_REACTOR_CONTEXT_OPERATOR_KEY);
        }

        <T> CoreSubscriber<T> createSubscriberIfNecessary(CoreSubscriber<T> delegate) {
            if (delegate.currentContext().hasKey((Object)"org.springframework.security.SECURITY_CONTEXT_ATTRIBUTES")) {
                return delegate;
            }
            return new SecurityReactorContextSubscriber<T>(delegate, SecurityReactorContextSubscriberRegistrar.getContextAttributes());
        }

        private static boolean contextAttributesAvailable() {
            return SecurityContextHolder.getContext().getAuthentication() != null || RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes;
        }

        private static Map<Object, Object> getContextAttributes() {
            Authentication authentication;
            HttpServletRequest servletRequest = null;
            HttpServletResponse servletResponse = null;
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes instanceof ServletRequestAttributes) {
                ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
                servletRequest = servletRequestAttributes.getRequest();
                servletResponse = servletRequestAttributes.getResponse();
            }
            if ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null && servletRequest == null) {
                return Collections.emptyMap();
            }
            HashMap<Object, Object> contextAttributes = new HashMap<Object, Object>();
            if (servletRequest != null) {
                contextAttributes.put(HttpServletRequest.class, servletRequest);
            }
            if (servletResponse != null) {
                contextAttributes.put(HttpServletResponse.class, servletResponse);
            }
            if (authentication != null) {
                contextAttributes.put(Authentication.class, authentication);
            }
            return contextAttributes;
        }
    }
}

