/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.dps.V2;

import com.contrastsecurity.cassandra.migration.api.JavaMigration;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.eaio.uuid.UUID;
import java.util.HashMap;
import java.util.Map;

public class V2_3__copy_errors_to_tables
implements JavaMigration {
    private static final String SELECT_NOTIFICATION_STATEMENT = "SELECT * FROM notifications;";
    private static final String UPDATE_BASIC_INFO_STATEMENT = "UPDATE basic_info set errors = ? where task_id = ?;";
    private static final String INSERT_ERROR_NOTIFICATIONS_STATEMENT = "INSERT INTO error_notifications (task_id,error_type,error_message,resource) VALUES (?,?,?,?);";
    private static final String UPDATE_ERROR_COUNTERS_STATEMENT = "UPDATE error_counters set error_count = error_count + 1 WHERE task_id = ? AND error_type = ?;";
    private static final String SUCCESS = "SUCCESS";
    private static final String STATE = "state";
    private static final String INFO = "info_text";
    private static final String TASK_ID = "task_id";
    private static final String RESOURCE = "resource";
    private PreparedStatement selectNotification;
    private PreparedStatement updateErrors;
    private PreparedStatement insertErrorNotifications;
    private PreparedStatement updateErrorCounters;

    @Override
    public void migrate(Session session) {
        this.initStatements(session);
        HashMap<Long, Map<String, Integer>> errorsPerTask = new HashMap<Long, Map<String, Integer>>();
        HashMap<String, String> errorTypes = new HashMap<String, String>();
        HashMap<Long, Integer> errorCounts = new HashMap<Long, Integer>();
        BoundStatement boundStatement = this.selectNotification.bind();
        boundStatement.setFetchSize(100);
        ResultSet rs = session.execute(boundStatement);
        for (Row notificationRow : rs) {
            if (SUCCESS.equals(notificationRow.getString(STATE))) continue;
            Long taskId = notificationRow.getLong(TASK_ID);
            String errorMessage = notificationRow.getString(INFO);
            if (errorMessage == null || errorMessage.isEmpty()) continue;
            String errorType = this.getErrorType(errorTypes, errorMessage);
            this.updateTables(session, errorType, errorMessage, taskId, notificationRow.getString(RESOURCE));
            this.increaseCounts(errorsPerTask, errorCounts, taskId, errorType);
        }
        this.updateErrorsForTasks(session, errorCounts);
    }

    private void updateErrorsForTasks(Session session, Map<Long, Integer> errorCounts) {
        for (Map.Entry<Long, Integer> entry : errorCounts.entrySet()) {
            BoundStatement bs = this.updateErrors.bind(entry.getValue(), entry.getKey());
            session.execute(bs);
        }
    }

    private void increaseCounts(Map<Long, Map<String, Integer>> errorsPerTask, Map<Long, Integer> errorCounts, Long taskId, String errorType) {
        Map<String, Integer> counts = this.getErrorCounts(errorsPerTask, taskId);
        Integer count = counts.get(errorType);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        counts.put(errorType, count);
        Integer allCount = errorCounts.get(taskId);
        if (allCount == null) {
            errorCounts.put(taskId, count);
        } else {
            errorCounts.put(taskId, allCount + 1);
        }
    }

    private Map<String, Integer> getErrorCounts(Map<Long, Map<String, Integer>> errorsPerTask, Long taskId) {
        Map<String, Integer> counts = errorsPerTask.get(taskId);
        if (counts == null) {
            counts = new HashMap<String, Integer>();
            errorsPerTask.put(taskId, counts);
        }
        return counts;
    }

    private String getErrorType(Map<String, String> errorTypes, String errorMessage) {
        String errorType = errorTypes.get(errorMessage);
        if (errorType == null) {
            errorType = new UUID().toString();
            errorTypes.put(errorMessage, errorType);
        }
        return errorType;
    }

    private void updateTables(Session session, String errorType, String errorMessage, long taskId, String resource) {
        BoundStatement bs = this.insertErrorNotifications.bind(taskId, java.util.UUID.fromString(errorType), errorMessage, resource);
        session.execute(bs);
        bs = this.updateErrorCounters.bind(taskId, java.util.UUID.fromString(errorType));
        session.execute(bs);
    }

    private void initStatements(Session session) {
        this.selectNotification = session.prepare(SELECT_NOTIFICATION_STATEMENT);
        this.selectNotification.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.updateErrors = session.prepare(UPDATE_BASIC_INFO_STATEMENT);
        this.updateErrors.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.insertErrorNotifications = session.prepare(INSERT_ERROR_NOTIFICATIONS_STATEMENT);
        this.insertErrorNotifications.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.updateErrorCounters = session.prepare(UPDATE_ERROR_COUNTERS_STATEMENT);
        this.updateErrorCounters.setConsistencyLevel(ConsistencyLevel.QUORUM);
    }
}

