/*
 * Decompiled with CFR 0.152.
 */
package migrations.common;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.Iterator;

public abstract class TableCopier {
    private static final int DEFAULT_RETRIES = 20;
    private static final long SLEEP_TIME = 1000L;

    public void copyTable(Session session, PreparedStatement selectStatement, PreparedStatement insertStatement) {
        insertStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        selectStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        long counter = 0L;
        BoundStatement boundStatement = selectStatement.bind();
        boundStatement.setFetchSize(100);
        ResultSet rs = session.execute(boundStatement);
        Iterator<Row> ri = rs.iterator();
        while (TableCopier.hasNextRow(ri)) {
            Row r = ri.next();
            this.insert(insertStatement, r, session);
            if (++counter % 10000L != 0L) continue;
            System.out.print("\rCopy table progress: " + counter);
        }
        if (counter > 0L) {
            System.out.println("\rCopy table progress: " + counter);
        }
    }

    public static boolean hasNextRow(Iterator<Row> iterator) {
        int retries = 20;
        while (retries-- > 0) {
            try {
                return iterator.hasNext();
            }
            catch (Exception e) {
                if (retries > 0) {
                    try {
                        System.out.println("Sleeping");
                        Thread.sleep(1000L * (long)(20 - retries));
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                System.out.println("Exception while copying table.\n" + e.getMessage());
                throw e;
            }
        }
        return false;
    }

    public abstract void insert(PreparedStatement var1, Row var2, Session var3);
}

