/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.utils;

import eu.europeana.cloud.common.annotation.Retryable;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableMethodExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryableMethodExecutor.class);
    public static final int DEFAULT_REST_ATTEMPTS = 8;
    public static final int DELAY_BETWEEN_REST_ATTEMPTS = 5000;

    public static <E extends Exception> void executeOnRest(String errorMessage, GenericRunnable<E> runnable) throws E {
        RetryableMethodExecutor.execute(errorMessage, 8, 5000, () -> {
            runnable.run();
            return null;
        });
    }

    public static <V, E extends Exception> V executeOnRest(String errorMessage, GenericCallable<V, E> callable) throws E {
        return RetryableMethodExecutor.execute(errorMessage, 8, 5000, callable);
    }

    public static <V, E extends Throwable> V execute(String errorMessage, int maxAttempts, int sleepTimeBetweenRetriesMs, GenericCallable<V, E> callable) throws E {
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (--maxAttempts > 0) {
                    LOGGER.warn("{} - {} Retries Left {} ", errorMessage, e.getMessage(), maxAttempts, e);
                    RetryableMethodExecutor.waitForSpecificTime(sleepTimeBetweenRetriesMs);
                    continue;
                }
                LOGGER.error(errorMessage);
                throw e;
            }
            break;
        }
    }

    private static void waitForSpecificTime(int milliSecond) {
        try {
            Thread.sleep(milliSecond);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Stop waiting for retry because interrupted flag set on Thread!", e);
        }
    }

    public static <T> T createRetryProxy(T target) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(target.getClass().getClassLoader());
        enhancer.setSuperclass(target.getClass());
        enhancer.setCallback((obj, method, args, methodProxy) -> RetryableMethodExecutor.retryFromAnnotation(target, method, args));
        return (T)enhancer.create();
    }

    static <T> Object retryFromAnnotation(T target, Method method, Object[] args) throws Throwable {
        Retryable retryAnnotation = method.getAnnotation(Retryable.class);
        if (retryAnnotation != null) {
            return RetryableMethodExecutor.execute(RetryableMethodExecutor.createMessage(method, retryAnnotation, args), retryAnnotation.maxAttempts(), retryAnnotation.delay(), () -> RetryableMethodExecutor.invokeWithThrowingOriginalException(target, method, args));
        }
        return RetryableMethodExecutor.invokeWithThrowingOriginalException(target, method, args);
    }

    private static <T> Object invokeWithThrowingOriginalException(T target, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (ReflectiveOperationException e) {
            throw e.getCause();
        }
    }

    public static String createMessage(Method method, Retryable annotation, Object[] args) {
        String result = !annotation.errorMessage().isEmpty() ? annotation.errorMessage() : String.format("Error while invoking method '%s' with args: %s", method, Arrays.toString(args));
        return result;
    }

    public static interface GenericCallable<V, E extends Throwable> {
        public V call() throws E;
    }

    public static interface GenericRunnable<E extends Exception> {
        public void run() throws E;
    }
}

