/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.net.httpclient;

import com.eaio.net.httpclient.ReEncodingRedirectStrategy;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

public class RedirectHttpResponseInterceptor
implements HttpResponseInterceptor {
    private static final String LAST_REDIRECT_URL = "last_redirect_url";

    public void process(HttpResponse response, HttpContext context) {
        if (context != null && response.containsHeader("Location")) {
            context.setAttribute(LAST_REDIRECT_URL, (Object)StringUtils.trimToNull(response.getFirstHeader("Location").getValue()));
        }
    }

    public static String getFinalURL(HttpContext context) {
        return RedirectHttpResponseInterceptor.getFinalURL(context, null);
    }

    public static String getFinalURL(HttpContext context, ReEncodingRedirectStrategy strategy) {
        String lastRedirectUrl = (String)context.getAttribute(LAST_REDIRECT_URL);
        HttpHost currentHost = (HttpHost)context.getAttribute("http.target_host");
        if (lastRedirectUrl == null) {
            HttpUriRequest currentReq = (HttpUriRequest)context.getAttribute("http.request");
            lastRedirectUrl = currentReq.getURI().isAbsolute() ? currentReq.getURI().toString() : String.valueOf(currentHost.toURI()) + currentReq.getURI();
        } else if (strategy != null) {
            lastRedirectUrl = URI.create(currentHost.toURI()).resolve(strategy.reEncode(lastRedirectUrl)).toString();
        }
        return lastRedirectUrl;
    }
}

