/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractData;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class BoundStatement
extends Statement
implements SettableData<BoundStatement>,
GettableData {
    private static final ByteBuffer UNSET = ByteBuffer.allocate(0);
    final PreparedStatement statement;
    final DataWrapper wrapper;
    private ByteBuffer routingKey;

    public BoundStatement(PreparedStatement statement) {
        this.statement = statement;
        this.wrapper = new DataWrapper(this, statement.getVariables().size());
        for (int i = 0; i < this.wrapper.values.length; ++i) {
            this.wrapper.values[i] = UNSET;
        }
        if (statement.getConsistencyLevel() != null) {
            this.setConsistencyLevel(statement.getConsistencyLevel());
        }
        if (statement.getSerialConsistencyLevel() != null) {
            this.setSerialConsistencyLevel(statement.getSerialConsistencyLevel());
        }
        if (statement.isTracing()) {
            this.enableTracing();
        }
        if (statement.getRetryPolicy() != null) {
            this.setRetryPolicy(statement.getRetryPolicy());
        }
    }

    public PreparedStatement preparedStatement() {
        return this.statement;
    }

    public boolean isSet(int i) {
        return this.wrapper.getValue(i) != UNSET;
    }

    public boolean isSet(String name) {
        return this.wrapper.getValue(this.wrapper.getIndexOf(name)) != UNSET;
    }

    public BoundStatement bind(Object ... values) {
        if (values.length > this.statement.getVariables().size()) {
            throw new IllegalArgumentException(String.format("Prepared statement has only %d variables, %d values provided", this.statement.getVariables().size(), values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            Object toSet = values[i];
            if (toSet == null) {
                this.wrapper.values[i] = null;
                continue;
            }
            DataType columnType = this.statement.getVariables().getType(i);
            switch (columnType.getName()) {
                case LIST: {
                    if (!(toSet instanceof List)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a list but %s provided", i, toSet.getClass()));
                    }
                    List l = (List)toSet;
                    if (l.isEmpty()) break;
                    Class<?> providedClass = l.get(0).getClass();
                    Class<?> expectedClass = columnType.getTypeArguments().get(0).asJavaClass();
                    if (expectedClass.isAssignableFrom(providedClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting list of %s but provided list of %s", i, columnType, expectedClass, providedClass));
                }
                case SET: {
                    Class<?> providedClass;
                    Class<?> expectedClass;
                    if (!(toSet instanceof Set)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a set but %s provided", i, toSet.getClass()));
                    }
                    Set s2 = (Set)toSet;
                    if (s2.isEmpty() || (expectedClass = columnType.getTypeArguments().get((int)0).getName().javaType).isAssignableFrom(providedClass = s2.iterator().next().getClass())) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting set of %s but provided set of %s", i, columnType, expectedClass, providedClass));
                }
                case MAP: {
                    if (!(toSet instanceof Map)) {
                        throw new InvalidTypeException(String.format("Invalid type for value %d, column is a map but %s provided", i, toSet.getClass()));
                    }
                    Map m3 = (Map)toSet;
                    if (m3.isEmpty()) break;
                    Map.Entry entry = m3.entrySet().iterator().next();
                    Class<?> providedKeysClass = entry.getKey().getClass();
                    Class<?> providedValuesClass = entry.getValue().getClass();
                    Class<?> expectedKeysClass = columnType.getTypeArguments().get((int)0).getName().javaType;
                    Class<?> expectedValuesClass = columnType.getTypeArguments().get((int)1).getName().javaType;
                    if (expectedKeysClass.isAssignableFrom(providedKeysClass) && expectedValuesClass.isAssignableFrom(providedValuesClass)) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting map of %s->%s but provided set of %s->%s", i, columnType, expectedKeysClass, expectedValuesClass, providedKeysClass, providedValuesClass));
                }
                default: {
                    Class<?> providedClass;
                    Class<?> expectedClass;
                    if (toSet instanceof Token) {
                        toSet = ((Token)toSet).getValue();
                    }
                    if ((expectedClass = columnType.getName().javaType).isAssignableFrom(providedClass = toSet.getClass())) break;
                    throw new InvalidTypeException(String.format("Invalid type for value %d of CQL type %s, expecting %s but %s provided", i, columnType, expectedClass, providedClass));
                }
            }
            this.wrapper.values[i] = columnType.codec(this.statement.getPreparedId().protocolVersion).serialize(toSet);
        }
        return this;
    }

    public BoundStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.routingKey != null) {
            return this.routingKey;
        }
        if (this.statement.getRoutingKey() != null) {
            return this.statement.getRoutingKey();
        }
        int[] rkIndexes = this.statement.getPreparedId().routingKeyIndexes;
        if (rkIndexes != null) {
            if (rkIndexes.length == 1) {
                return this.wrapper.values[rkIndexes[0]];
            }
            ByteBuffer[] components = new ByteBuffer[rkIndexes.length];
            for (int i = 0; i < components.length; ++i) {
                ByteBuffer value = this.wrapper.values[rkIndexes[i]];
                if (value == null) {
                    return null;
                }
                components[i] = value;
            }
            return SimpleStatement.compose(components);
        }
        return null;
    }

    @Override
    public String getKeyspace() {
        return this.statement.getPreparedId().metadata.size() == 0 ? null : this.statement.getPreparedId().metadata.getKeyspace(0);
    }

    @Override
    public BoundStatement setBool(int i, boolean v) {
        return (BoundStatement)this.wrapper.setBool(i, v);
    }

    @Override
    public BoundStatement setBool(String name, boolean v) {
        return (BoundStatement)this.wrapper.setBool(name, v);
    }

    @Override
    public BoundStatement setInt(int i, int v) {
        return (BoundStatement)this.wrapper.setInt(i, v);
    }

    @Override
    public BoundStatement setInt(String name, int v) {
        return (BoundStatement)this.wrapper.setInt(name, v);
    }

    @Override
    public BoundStatement setLong(int i, long v) {
        return (BoundStatement)this.wrapper.setLong(i, v);
    }

    @Override
    public BoundStatement setLong(String name, long v) {
        return (BoundStatement)this.wrapper.setLong(name, v);
    }

    @Override
    public BoundStatement setDate(int i, Date v) {
        return (BoundStatement)this.wrapper.setDate(i, v);
    }

    @Override
    public BoundStatement setDate(String name, Date v) {
        return (BoundStatement)this.wrapper.setDate(name, v);
    }

    @Override
    public BoundStatement setFloat(int i, float v) {
        return (BoundStatement)this.wrapper.setFloat(i, v);
    }

    @Override
    public BoundStatement setFloat(String name, float v) {
        return (BoundStatement)this.wrapper.setFloat(name, v);
    }

    @Override
    public BoundStatement setDouble(int i, double v) {
        return (BoundStatement)this.wrapper.setDouble(i, v);
    }

    @Override
    public BoundStatement setDouble(String name, double v) {
        return (BoundStatement)this.wrapper.setDouble(name, v);
    }

    @Override
    public BoundStatement setString(int i, String v) {
        return (BoundStatement)this.wrapper.setString(i, v);
    }

    @Override
    public BoundStatement setString(String name, String v) {
        return (BoundStatement)this.wrapper.setString(name, v);
    }

    @Override
    public BoundStatement setBytes(int i, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytes(i, v);
    }

    @Override
    public BoundStatement setBytes(String name, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytes(name, v);
    }

    @Override
    public BoundStatement setBytesUnsafe(int i, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytesUnsafe(i, v);
    }

    @Override
    public BoundStatement setBytesUnsafe(String name, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytesUnsafe(name, v);
    }

    @Override
    public BoundStatement setVarint(int i, BigInteger v) {
        return (BoundStatement)this.wrapper.setVarint(i, v);
    }

    @Override
    public BoundStatement setVarint(String name, BigInteger v) {
        return (BoundStatement)this.wrapper.setVarint(name, v);
    }

    @Override
    public BoundStatement setDecimal(int i, BigDecimal v) {
        return (BoundStatement)this.wrapper.setDecimal(i, v);
    }

    @Override
    public BoundStatement setDecimal(String name, BigDecimal v) {
        return (BoundStatement)this.wrapper.setDecimal(name, v);
    }

    @Override
    public BoundStatement setUUID(int i, UUID v) {
        return (BoundStatement)this.wrapper.setUUID(i, v);
    }

    @Override
    public BoundStatement setUUID(String name, UUID v) {
        return (BoundStatement)this.wrapper.setUUID(name, v);
    }

    @Override
    public BoundStatement setInet(int i, InetAddress v) {
        return (BoundStatement)this.wrapper.setInet(i, v);
    }

    @Override
    public BoundStatement setInet(String name, InetAddress v) {
        return (BoundStatement)this.wrapper.setInet(name, v);
    }

    public BoundStatement setToken(int i, Token v) {
        return (BoundStatement)this.wrapper.setToken(i, v);
    }

    public BoundStatement setToken(String name, Token v) {
        return (BoundStatement)this.wrapper.setToken(name, v);
    }

    public BoundStatement setPartitionKeyToken(Token v) {
        return this.setToken("partition key token", v);
    }

    @Override
    public <T> BoundStatement setList(int i, List<T> v) {
        return (BoundStatement)this.wrapper.setList(i, (List)v);
    }

    @Override
    public <T> BoundStatement setList(String name, List<T> v) {
        return (BoundStatement)this.wrapper.setList(name, v);
    }

    @Override
    public <K, V> BoundStatement setMap(int i, Map<K, V> v) {
        return (BoundStatement)this.wrapper.setMap(i, (Map)v);
    }

    @Override
    public <K, V> BoundStatement setMap(String name, Map<K, V> v) {
        return (BoundStatement)this.wrapper.setMap(name, v);
    }

    @Override
    public <T> BoundStatement setSet(int i, Set<T> v) {
        return (BoundStatement)this.wrapper.setSet(i, (Set)v);
    }

    @Override
    public <T> BoundStatement setSet(String name, Set<T> v) {
        return (BoundStatement)this.wrapper.setSet(name, v);
    }

    @Override
    public BoundStatement setUDTValue(int i, UDTValue v) {
        return (BoundStatement)this.wrapper.setUDTValue(i, v);
    }

    @Override
    public BoundStatement setUDTValue(String name, UDTValue v) {
        return (BoundStatement)this.wrapper.setUDTValue(name, v);
    }

    @Override
    public BoundStatement setTupleValue(int i, TupleValue v) {
        return (BoundStatement)this.wrapper.setTupleValue(i, v);
    }

    @Override
    public BoundStatement setTupleValue(String name, TupleValue v) {
        return (BoundStatement)this.wrapper.setTupleValue(name, v);
    }

    @Override
    public BoundStatement setToNull(int i) {
        return (BoundStatement)this.wrapper.setToNull(i);
    }

    @Override
    public BoundStatement setToNull(String name) {
        return (BoundStatement)this.wrapper.setToNull(name);
    }

    @Override
    public boolean isNull(int i) {
        return this.wrapper.isNull(i);
    }

    @Override
    public boolean isNull(String name) {
        return this.wrapper.isNull(name);
    }

    @Override
    public boolean getBool(int i) {
        return this.wrapper.getBool(i);
    }

    @Override
    public boolean getBool(String name) {
        return this.wrapper.getBool(name);
    }

    @Override
    public int getInt(int i) {
        return this.wrapper.getInt(i);
    }

    @Override
    public int getInt(String name) {
        return this.wrapper.getInt(name);
    }

    @Override
    public long getLong(int i) {
        return this.wrapper.getLong(i);
    }

    @Override
    public long getLong(String name) {
        return this.wrapper.getLong(name);
    }

    @Override
    public Date getDate(int i) {
        return this.wrapper.getDate(i);
    }

    @Override
    public Date getDate(String name) {
        return this.wrapper.getDate(name);
    }

    @Override
    public float getFloat(int i) {
        return this.wrapper.getFloat(i);
    }

    @Override
    public float getFloat(String name) {
        return this.wrapper.getFloat(name);
    }

    @Override
    public double getDouble(int i) {
        return this.wrapper.getDouble(i);
    }

    @Override
    public double getDouble(String name) {
        return this.wrapper.getDouble(name);
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        return this.wrapper.getBytesUnsafe(i);
    }

    @Override
    public ByteBuffer getBytesUnsafe(String name) {
        return this.wrapper.getBytesUnsafe(name);
    }

    @Override
    public ByteBuffer getBytes(int i) {
        return this.wrapper.getBytes(i);
    }

    @Override
    public ByteBuffer getBytes(String name) {
        return this.wrapper.getBytes(name);
    }

    @Override
    public String getString(int i) {
        return this.wrapper.getString(i);
    }

    @Override
    public String getString(String name) {
        return this.wrapper.getString(name);
    }

    @Override
    public BigInteger getVarint(int i) {
        return this.wrapper.getVarint(i);
    }

    @Override
    public BigInteger getVarint(String name) {
        return this.wrapper.getVarint(name);
    }

    @Override
    public BigDecimal getDecimal(int i) {
        return this.wrapper.getDecimal(i);
    }

    @Override
    public BigDecimal getDecimal(String name) {
        return this.wrapper.getDecimal(name);
    }

    @Override
    public UUID getUUID(int i) {
        return this.wrapper.getUUID(i);
    }

    @Override
    public UUID getUUID(String name) {
        return this.wrapper.getUUID(name);
    }

    @Override
    public InetAddress getInet(int i) {
        return this.wrapper.getInet(i);
    }

    @Override
    public InetAddress getInet(String name) {
        return this.wrapper.getInet(name);
    }

    @Override
    public <T> List<T> getList(int i, Class<T> elementsClass) {
        return this.wrapper.getList(i, (Class)elementsClass);
    }

    @Override
    public <T> List<T> getList(int i, TypeToken<T> elementsType) {
        return this.wrapper.getList(i, (TypeToken)elementsType);
    }

    @Override
    public <T> List<T> getList(String name, Class<T> elementsClass) {
        return this.wrapper.getList(name, elementsClass);
    }

    @Override
    public <T> List<T> getList(String name, TypeToken<T> elementsType) {
        return this.wrapper.getList(name, elementsType);
    }

    @Override
    public <T> Set<T> getSet(int i, Class<T> elementsClass) {
        return this.wrapper.getSet(i, (Class)elementsClass);
    }

    @Override
    public <T> Set<T> getSet(int i, TypeToken<T> elementsType) {
        return this.wrapper.getSet(i, (TypeToken)elementsType);
    }

    @Override
    public <T> Set<T> getSet(String name, Class<T> elementsClass) {
        return this.wrapper.getSet(name, elementsClass);
    }

    @Override
    public <T> Set<T> getSet(String name, TypeToken<T> elementsType) {
        return this.wrapper.getSet(name, elementsType);
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
        return this.wrapper.getMap(i, (Class)keysClass, (Class)valuesClass);
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return this.wrapper.getMap(i, (TypeToken)keysType, (TypeToken)valuesType);
    }

    @Override
    public <K, V> Map<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
        return this.wrapper.getMap(name, keysClass, valuesClass);
    }

    @Override
    public <K, V> Map<K, V> getMap(String name, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return this.wrapper.getMap(name, keysType, valuesType);
    }

    @Override
    public UDTValue getUDTValue(int i) {
        return this.wrapper.getUDTValue(i);
    }

    @Override
    public UDTValue getUDTValue(String name) {
        return this.wrapper.getUDTValue(name);
    }

    @Override
    public TupleValue getTupleValue(int i) {
        return this.wrapper.getTupleValue(i);
    }

    @Override
    public TupleValue getTupleValue(String name) {
        return this.wrapper.getTupleValue(name);
    }

    @Override
    public Object getObject(int i) {
        return this.wrapper.getObject(i);
    }

    @Override
    public Object getObject(String name) {
        return this.wrapper.getObject(name);
    }

    void ensureAllSet() {
        int index = 0;
        for (ByteBuffer value : this.wrapper.values) {
            if (value == UNSET) {
                throw new IllegalStateException("Unset value at index " + index + ". " + "If you want this value to be null, please set it to null explicitly.");
            }
            ++index;
        }
    }

    static class DataWrapper
    extends AbstractData<BoundStatement> {
        DataWrapper(BoundStatement wrapped, int size) {
            super(wrapped.statement.getPreparedId().protocolVersion, wrapped, size);
        }

        @Override
        protected int[] getAllIndexesOf(String name) {
            return ((BoundStatement)this.wrapped).statement.getVariables().getAllIdx(name);
        }

        @Override
        protected DataType getType(int i) {
            return ((BoundStatement)this.wrapped).statement.getVariables().getType(i);
        }

        @Override
        protected String getName(int i) {
            return ((BoundStatement)this.wrapped).statement.getVariables().getName(i);
        }
    }
}

