/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AsyncInitSession;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;

public abstract class AbstractSession
implements Session,
AsyncInitSession {
    @Override
    public ResultSet execute(String query2) {
        return this.execute(new SimpleStatement(query2));
    }

    @Override
    public ResultSet execute(String query2, Object ... values) {
        return this.execute(new SimpleStatement(query2, values));
    }

    @Override
    public ResultSet execute(Statement statement) {
        return this.executeAsync(statement).getUninterruptibly();
    }

    @Override
    public ResultSetFuture executeAsync(String query2) {
        return this.executeAsync(new SimpleStatement(query2));
    }

    @Override
    public ResultSetFuture executeAsync(String query2, Object ... values) {
        return this.executeAsync(new SimpleStatement(query2, values));
    }

    @Override
    public PreparedStatement prepare(String query2) {
        try {
            return Uninterruptibles.getUninterruptibly(this.prepareAsync(query2));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        try {
            return Uninterruptibles.getUninterruptibly(this.prepareAsync(statement));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(final RegularStatement statement) {
        if (statement.hasValues()) {
            throw new IllegalArgumentException("A statement to prepare should not have values");
        }
        ListenableFuture<PreparedStatement> prepared = this.prepareAsync(statement.toString());
        return Futures.transform(prepared, (Function)new Function<PreparedStatement, PreparedStatement>(){

            @Override
            public PreparedStatement apply(PreparedStatement prepared) {
                ByteBuffer routingKey = statement.getRoutingKey();
                if (routingKey != null) {
                    prepared.setRoutingKey(routingKey);
                }
                prepared.setConsistencyLevel(statement.getConsistencyLevel());
                if (statement.isTracing()) {
                    prepared.enableTracing();
                }
                prepared.setRetryPolicy(statement.getRetryPolicy());
                return prepared;
            }
        });
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

