/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.utils.scanner;

import com.contrastsecurity.cassandra.migration.CassandraMigrationException;
import com.contrastsecurity.cassandra.migration.config.ScriptsLocation;
import com.contrastsecurity.cassandra.migration.utils.scanner.Resource;
import com.contrastsecurity.cassandra.migration.utils.scanner.classpath.ClassPathScanner;
import com.contrastsecurity.cassandra.migration.utils.scanner.filesystem.FileSystemScanner;

public class Scanner {
    private final ClassLoader classLoader;

    public Scanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Resource[] scanForResources(ScriptsLocation location, String prefix, String suffix) {
        try {
            if (location.isFileSystem()) {
                return new FileSystemScanner().scanForResources(location.getPath(), prefix, suffix);
            }
            return new ClassPathScanner(this.classLoader).scanForResources(location.getPath(), prefix, suffix);
        }
        catch (Exception e) {
            throw new CassandraMigrationException("Unable to scan for CQL migrations in location: " + location, e);
        }
    }

    public Class<?>[] scanForClasses(ScriptsLocation location, Class<?> implementedInterface) throws Exception {
        return new ClassPathScanner(this.classLoader).scanForClasses(location.getPath(), implementedInterface);
    }
}

