/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.script;

import com.contrastsecurity.cassandra.migration.CassandraMigrationException;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.contrastsecurity.cassandra.migration.script.CqlStatementBuilder;
import com.contrastsecurity.cassandra.migration.script.Delimiter;
import com.contrastsecurity.cassandra.migration.utils.StringUtils;
import com.contrastsecurity.cassandra.migration.utils.scanner.Resource;
import com.datastax.driver.core.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class CqlScript {
    private static final Log LOG = LogFactory.getLog(CqlScript.class);
    private final List<String> cqlStatements;
    private final Resource resource;

    public CqlScript(String cqlScriptSource) {
        this.cqlStatements = this.parse(cqlScriptSource);
        this.resource = null;
    }

    public CqlScript(Resource cqlScriptResource, String encoding) {
        String cqlScriptSource = cqlScriptResource.loadAsString(encoding);
        this.cqlStatements = this.parse(cqlScriptSource);
        this.resource = cqlScriptResource;
    }

    public List<String> getCqlStatements() {
        return this.cqlStatements;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void execute(Session session) {
        for (String cqlStatement : this.cqlStatements) {
            LOG.debug("Executing CQL: " + cqlStatement);
            session.execute(cqlStatement);
        }
    }

    List<String> parse(String cqlScriptSource) {
        return this.linesToStatements(this.readLines(new StringReader(cqlScriptSource)));
    }

    List<String> linesToStatements(List<String> lines) {
        ArrayList<String> statements = new ArrayList<String>();
        Delimiter nonStandardDelimiter = null;
        CqlStatementBuilder cqlStatementBuilder = new CqlStatementBuilder();
        for (int lineNumber = 1; lineNumber <= lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber - 1);
            if (cqlStatementBuilder.isEmpty()) {
                if (!StringUtils.hasText(line)) continue;
                Delimiter newDelimiter = cqlStatementBuilder.extractNewDelimiterFromLine(line);
                if (newDelimiter != null) {
                    nonStandardDelimiter = newDelimiter;
                    continue;
                }
                cqlStatementBuilder.setLineNumber(lineNumber);
                if (nonStandardDelimiter != null) {
                    cqlStatementBuilder.setDelimiter(nonStandardDelimiter);
                }
            }
            cqlStatementBuilder.addLine(line);
            if (cqlStatementBuilder.isTerminated()) {
                String cqlStatement = cqlStatementBuilder.getCqlStatement();
                statements.add(cqlStatement);
                LOG.debug("Found statement: " + cqlStatement);
                cqlStatementBuilder = new CqlStatementBuilder();
                continue;
            }
            if (!cqlStatementBuilder.canDiscard()) continue;
            cqlStatementBuilder = new CqlStatementBuilder();
        }
        if (!cqlStatementBuilder.isEmpty()) {
            statements.add(cqlStatementBuilder.getCqlStatement());
        }
        return statements;
    }

    private List<String> readLines(Reader reader) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            String message = this.resource == null ? "Unable to parse lines" : "Unable to parse " + this.resource.getLocation() + " (" + this.resource.getLocationOnDisk() + ")";
            throw new CassandraMigrationException(message, e);
        }
        return lines;
    }
}

