/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.resolver.java;

import com.contrastsecurity.cassandra.migration.CassandraMigrationException;
import com.contrastsecurity.cassandra.migration.api.JavaMigration;
import com.contrastsecurity.cassandra.migration.api.MigrationChecksumProvider;
import com.contrastsecurity.cassandra.migration.api.MigrationInfoProvider;
import com.contrastsecurity.cassandra.migration.config.MigrationType;
import com.contrastsecurity.cassandra.migration.config.ScriptsLocation;
import com.contrastsecurity.cassandra.migration.info.MigrationVersion;
import com.contrastsecurity.cassandra.migration.info.ResolvedMigration;
import com.contrastsecurity.cassandra.migration.resolver.MigrationInfoHelper;
import com.contrastsecurity.cassandra.migration.resolver.MigrationResolver;
import com.contrastsecurity.cassandra.migration.resolver.ResolvedMigrationComparator;
import com.contrastsecurity.cassandra.migration.resolver.java.JavaMigrationExecutor;
import com.contrastsecurity.cassandra.migration.utils.ClassUtils;
import com.contrastsecurity.cassandra.migration.utils.Pair;
import com.contrastsecurity.cassandra.migration.utils.StringUtils;
import com.contrastsecurity.cassandra.migration.utils.scanner.Scanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaMigrationResolver
implements MigrationResolver {
    private final ScriptsLocation location;
    private ClassLoader classLoader;

    public JavaMigrationResolver(ClassLoader classLoader, ScriptsLocation location) {
        this.location = location;
        this.classLoader = classLoader;
    }

    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        if (!this.location.isClassPath()) {
            return migrations;
        }
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = new Scanner(this.classLoader).scanForClasses(this.location, JavaMigration.class)) {
                JavaMigration javaMigration = (JavaMigration)ClassUtils.instantiate(clazz.getName(), this.classLoader);
                ResolvedMigration migrationInfo = this.extractMigrationInfo(javaMigration);
                migrationInfo.setPhysicalLocation(ClassUtils.getLocationOnDisk(clazz));
                migrationInfo.setExecutor(new JavaMigrationExecutor(javaMigration));
                migrations.add(migrationInfo);
            }
        }
        catch (Exception e) {
            throw new CassandraMigrationException("Unable to resolve Java migrations in location: " + this.location, e);
        }
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    ResolvedMigration extractMigrationInfo(JavaMigration javaMigration) {
        String description;
        MigrationVersion version;
        Integer checksum = null;
        if (javaMigration instanceof MigrationChecksumProvider) {
            MigrationChecksumProvider checksumProvider = (MigrationChecksumProvider)((Object)javaMigration);
            checksum = checksumProvider.getChecksum();
        }
        if (javaMigration instanceof MigrationInfoProvider) {
            MigrationInfoProvider infoProvider = (MigrationInfoProvider)((Object)javaMigration);
            version = infoProvider.getVersion();
            description = infoProvider.getDescription();
            if (!StringUtils.hasText(description)) {
                throw new CassandraMigrationException("Missing description for migration " + version);
            }
        } else {
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(ClassUtils.getShortName(javaMigration.getClass()), "V", "__", "");
            version = info.getLeft();
            description = info.getRight();
        }
        String script = javaMigration.getClass().getName();
        ResolvedMigration resolvedMigration = new ResolvedMigration();
        resolvedMigration.setVersion(version);
        resolvedMigration.setDescription(description);
        resolvedMigration.setScript(script);
        resolvedMigration.setChecksum(checksum);
        resolvedMigration.setType(MigrationType.JAVA_DRIVER);
        return resolvedMigration;
    }
}

