/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.resolver;

import com.contrastsecurity.cassandra.migration.CassandraMigrationException;
import com.contrastsecurity.cassandra.migration.config.ScriptsLocation;
import com.contrastsecurity.cassandra.migration.config.ScriptsLocations;
import com.contrastsecurity.cassandra.migration.info.ResolvedMigration;
import com.contrastsecurity.cassandra.migration.resolver.MigrationResolver;
import com.contrastsecurity.cassandra.migration.resolver.ResolvedMigrationComparator;
import com.contrastsecurity.cassandra.migration.resolver.cql.CqlMigrationResolver;
import com.contrastsecurity.cassandra.migration.resolver.java.JavaMigrationResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CompositeMigrationResolver
implements MigrationResolver {
    private Collection<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
    private List<ResolvedMigration> availableMigrations;

    public CompositeMigrationResolver(ClassLoader classLoader, ScriptsLocations locations, String encoding, MigrationResolver ... customMigrationResolvers) {
        for (ScriptsLocation location : locations.getLocations()) {
            this.migrationResolvers.add(new CqlMigrationResolver(classLoader, location, encoding));
            this.migrationResolvers.add(new JavaMigrationResolver(classLoader, location));
        }
        this.migrationResolvers.addAll(Arrays.asList(customMigrationResolvers));
    }

    public List<ResolvedMigration> resolveMigrations() {
        if (this.availableMigrations == null) {
            this.availableMigrations = this.doFindAvailableMigrations();
        }
        return this.availableMigrations;
    }

    private List<ResolvedMigration> doFindAvailableMigrations() throws CassandraMigrationException {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>(CompositeMigrationResolver.collectMigrations(this.migrationResolvers));
        Collections.sort(migrations, new ResolvedMigrationComparator());
        CompositeMigrationResolver.checkForIncompatibilities(migrations);
        return migrations;
    }

    static Collection<ResolvedMigration> collectMigrations(Collection<MigrationResolver> migrationResolvers) {
        HashSet<ResolvedMigration> migrations = new HashSet<ResolvedMigration>();
        for (MigrationResolver migrationResolver : migrationResolvers) {
            migrations.addAll(migrationResolver.resolveMigrations());
        }
        return migrations;
    }

    static void checkForIncompatibilities(List<ResolvedMigration> migrations) {
        for (int i = 0; i < migrations.size() - 1; ++i) {
            ResolvedMigration current = migrations.get(i);
            ResolvedMigration next = migrations.get(i + 1);
            if (current.getVersion().compareTo(next.getVersion()) != 0) continue;
            throw new CassandraMigrationException(String.format("Found more than one migration with version %s\nOffenders:\n-> %s (%s)\n-> %s (%s)", new Object[]{current.getVersion(), current.getPhysicalLocation(), current.getType(), next.getPhysicalLocation(), next.getType()}));
        }
    }
}

