/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.logging;

import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogCreator;
import com.contrastsecurity.cassandra.migration.logging.apachecommons.ApacheCommonsLogCreator;
import com.contrastsecurity.cassandra.migration.logging.javautil.JavaUtilLogCreator;
import com.contrastsecurity.cassandra.migration.logging.slf4j.Slf4jLogCreator;
import com.contrastsecurity.cassandra.migration.utils.FeatureDetector;

public class LogFactory {
    private static LogCreator logCreator;

    private LogFactory() {
    }

    public static void setLogCreator(LogCreator logCreator) {
        LogFactory.logCreator = logCreator;
    }

    public static Log getLog(Class<?> clazz) {
        if (logCreator == null) {
            FeatureDetector featureDetector = new FeatureDetector(Thread.currentThread().getContextClassLoader());
            logCreator = featureDetector.isSlf4jAvailable() ? new Slf4jLogCreator() : (featureDetector.isApacheCommonsLoggingAvailable() ? new ApacheCommonsLogCreator() : new JavaUtilLogCreator());
        }
        return logCreator.createLogger(clazz);
    }
}

