/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.info;

import com.contrastsecurity.cassandra.migration.info.MigrationInfo;
import com.contrastsecurity.cassandra.migration.utils.DateUtils;
import com.contrastsecurity.cassandra.migration.utils.StringUtils;

public class MigrationInfoDumper {
    private static final String VERSION_TITLE = "Version";
    private static final String DESCRIPTION_TITLE = "Description";

    private MigrationInfoDumper() {
    }

    public static String dumpToAsciiTable(MigrationInfo[] migrationInfos) {
        int versionWidth = VERSION_TITLE.length();
        int descriptionWidth = DESCRIPTION_TITLE.length();
        for (MigrationInfo migrationInfo : migrationInfos) {
            versionWidth = Math.max(versionWidth, migrationInfo.getVersion().toString().length());
            descriptionWidth = Math.max(descriptionWidth, migrationInfo.getDescription().length());
        }
        String ruler = "+-" + StringUtils.trimOrPad("", versionWidth, '-') + "-+-" + StringUtils.trimOrPad("", descriptionWidth, '-') + "-+---------------------+---------+\n";
        StringBuilder table = new StringBuilder();
        table.append(ruler);
        table.append("| ").append(StringUtils.trimOrPad(VERSION_TITLE, versionWidth, ' ')).append(" | ").append(StringUtils.trimOrPad(DESCRIPTION_TITLE, descriptionWidth)).append(" | Installed on        | State   |\n");
        table.append(ruler);
        if (migrationInfos.length == 0) {
            table.append(StringUtils.trimOrPad("| No migrations found", ruler.length() - 2, ' ')).append("|\n");
        } else {
            for (MigrationInfo migrationInfo : migrationInfos) {
                table.append("| ").append(StringUtils.trimOrPad(migrationInfo.getVersion().toString(), versionWidth));
                table.append(" | ").append(StringUtils.trimOrPad(migrationInfo.getDescription(), descriptionWidth));
                table.append(" | ").append(StringUtils.trimOrPad(DateUtils.formatDateAsIsoString(migrationInfo.getInstalledOn()), 19));
                table.append(" | ").append(StringUtils.trimOrPad(migrationInfo.getState().getDisplayName(), 7));
                table.append(" |\n");
            }
        }
        table.append(ruler);
        return table.toString();
    }
}

