/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.info;

import com.contrastsecurity.cassandra.migration.config.MigrationType;
import com.contrastsecurity.cassandra.migration.info.AppliedMigration;
import com.contrastsecurity.cassandra.migration.info.MigrationInfoContext;
import com.contrastsecurity.cassandra.migration.info.MigrationState;
import com.contrastsecurity.cassandra.migration.info.MigrationVersion;
import com.contrastsecurity.cassandra.migration.info.ResolvedMigration;
import com.contrastsecurity.cassandra.migration.utils.ObjectUtils;
import java.util.Date;

public class MigrationInfo
implements Comparable<MigrationInfo> {
    private final ResolvedMigration resolvedMigration;
    private final AppliedMigration appliedMigration;
    private final MigrationInfoContext context;

    public MigrationInfo(ResolvedMigration resolvedMigration, AppliedMigration appliedMigration, MigrationInfoContext context) {
        this.resolvedMigration = resolvedMigration;
        this.appliedMigration = appliedMigration;
        this.context = context;
    }

    public ResolvedMigration getResolvedMigration() {
        return this.resolvedMigration;
    }

    public AppliedMigration getAppliedMigration() {
        return this.appliedMigration;
    }

    public MigrationType getType() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getType();
        }
        return this.resolvedMigration.getType();
    }

    public Integer getChecksum() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getChecksum();
        }
        return this.resolvedMigration.getChecksum();
    }

    public MigrationVersion getVersion() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getVersion();
        }
        return this.resolvedMigration.getVersion();
    }

    public String getDescription() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getDescription();
        }
        return this.resolvedMigration.getDescription();
    }

    public String getScript() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getScript();
        }
        return this.resolvedMigration.getScript();
    }

    public MigrationState getState() {
        if (this.appliedMigration == null) {
            if (this.resolvedMigration.getVersion().compareTo(this.context.baseline) < 0) {
                return MigrationState.BELOW_BASELINE;
            }
            if (this.resolvedMigration.getVersion().compareTo(this.context.target) > 0) {
                return MigrationState.ABOVE_TARGET;
            }
            if (this.resolvedMigration.getVersion().compareTo(this.context.lastApplied) < 0 && !this.context.outOfOrder) {
                return MigrationState.IGNORED;
            }
            return MigrationState.PENDING;
        }
        if (this.resolvedMigration == null) {
            if (MigrationType.SCHEMA == this.appliedMigration.getType()) {
                return MigrationState.SUCCESS;
            }
            if (MigrationType.BASELINE == this.appliedMigration.getType()) {
                return MigrationState.BASELINE;
            }
            if (this.getVersion().compareTo(this.context.lastResolved) < 0) {
                if (this.appliedMigration.isSuccess()) {
                    return MigrationState.MISSING_SUCCESS;
                }
                return MigrationState.MISSING_FAILED;
            }
            if (this.getVersion().compareTo(this.context.lastResolved) > 0) {
                if (this.appliedMigration.isSuccess()) {
                    return MigrationState.FUTURE_SUCCESS;
                }
                return MigrationState.FUTURE_FAILED;
            }
        }
        if (this.appliedMigration.isSuccess()) {
            if (this.appliedMigration.getVersionRank() == this.appliedMigration.getInstalledRank()) {
                return MigrationState.SUCCESS;
            }
            return MigrationState.OUT_OF_ORDER;
        }
        return MigrationState.FAILED;
    }

    public Date getInstalledOn() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledOn();
        }
        return null;
    }

    public Integer getExecutionTime() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getExecutionTime();
        }
        return null;
    }

    public String validate() {
        if (!this.context.pendingOrFuture && this.resolvedMigration == null && this.appliedMigration.getType() != MigrationType.SCHEMA && this.appliedMigration.getType() != MigrationType.BASELINE) {
            return "Detected applied migration not resolved locally: " + this.getVersion();
        }
        if (!this.context.pendingOrFuture && MigrationState.PENDING == this.getState() || MigrationState.IGNORED == this.getState()) {
            return "Detected resolved migration not applied to database: " + this.getVersion();
        }
        if (this.resolvedMigration != null && this.appliedMigration != null && this.getVersion().compareTo(this.context.baseline) > 0) {
            if (this.resolvedMigration.getType() != this.appliedMigration.getType()) {
                return this.createMismatchMessage("Type", this.appliedMigration.getVersion(), (Object)this.appliedMigration.getType(), (Object)this.resolvedMigration.getType());
            }
            if (!ObjectUtils.nullSafeEquals(this.resolvedMigration.getChecksum(), this.appliedMigration.getChecksum())) {
                return this.createMismatchMessage("Checksum", this.appliedMigration.getVersion(), this.appliedMigration.getChecksum(), this.resolvedMigration.getChecksum());
            }
            if (!this.resolvedMigration.getDescription().equals(this.appliedMigration.getDescription())) {
                return this.createMismatchMessage("Description", this.appliedMigration.getVersion(), this.appliedMigration.getDescription(), this.resolvedMigration.getDescription());
            }
        }
        return null;
    }

    private String createMismatchMessage(String mismatch, MigrationVersion version, Object applied, Object resolved) {
        return String.format("Migration " + mismatch + " mismatch for migration %s\n" + "-> Applied to database : %s\n" + "-> Resolved locally    : %s", version, applied, resolved);
    }

    @Override
    public int compareTo(MigrationInfo o) {
        return this.getVersion().compareTo(o.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInfo that = (MigrationInfo)o;
        if (this.appliedMigration != null ? !this.appliedMigration.equals(that.appliedMigration) : that.appliedMigration != null) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        return !(this.resolvedMigration == null ? that.resolvedMigration != null : !this.resolvedMigration.equals(that.resolvedMigration));
    }

    public int hashCode() {
        int result = this.resolvedMigration != null ? this.resolvedMigration.hashCode() : 0;
        result = 31 * result + (this.appliedMigration != null ? this.appliedMigration.hashCode() : 0);
        result = 31 * result + this.context.hashCode();
        return result;
    }
}

