/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.config;

import com.contrastsecurity.cassandra.migration.config.ScriptsLocation;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScriptsLocations {
    private static final Log LOG = LogFactory.getLog(ScriptsLocations.class);
    private final List<ScriptsLocation> locations = new ArrayList<ScriptsLocation>();

    public ScriptsLocations(String ... rawLocations) {
        ArrayList<ScriptsLocation> normalizedLocations = new ArrayList<ScriptsLocation>();
        for (String rawLocation : rawLocations) {
            normalizedLocations.add(new ScriptsLocation(rawLocation));
        }
        Collections.sort(normalizedLocations);
        for (ScriptsLocation normalizedLocation : normalizedLocations) {
            if (this.locations.contains(normalizedLocation)) {
                LOG.warn("Discarding duplicate location '" + normalizedLocation + "'");
                continue;
            }
            ScriptsLocation parentLocation = this.getParentLocationIfExists(normalizedLocation, this.locations);
            if (parentLocation != null) {
                LOG.warn("Discarding location '" + normalizedLocation + "' as it is a sublocation of '" + parentLocation + "'");
                continue;
            }
            this.locations.add(normalizedLocation);
        }
    }

    public List<ScriptsLocation> getLocations() {
        return this.locations;
    }

    private ScriptsLocation getParentLocationIfExists(ScriptsLocation location, List<ScriptsLocation> finalLocations) {
        for (ScriptsLocation finalLocation : finalLocations) {
            if (!finalLocation.isParentOf(location)) continue;
            return finalLocation;
        }
        return null;
    }
}

