/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.config;

import com.contrastsecurity.cassandra.migration.CassandraMigrationException;

public final class ScriptsLocation
implements Comparable<ScriptsLocation> {
    private static final String CLASSPATH_PREFIX = "classpath:";
    public static final String FILESYSTEM_PREFIX = "filesystem:";
    private String prefix;
    private String path;

    public ScriptsLocation(String descriptor) {
        String normalizedDescriptor = descriptor.trim().replace("\\", "/");
        if (normalizedDescriptor.contains(":")) {
            this.prefix = normalizedDescriptor.substring(0, normalizedDescriptor.indexOf(":") + 1);
            this.path = normalizedDescriptor.substring(normalizedDescriptor.indexOf(":") + 1);
        } else {
            this.prefix = CLASSPATH_PREFIX;
            this.path = normalizedDescriptor;
        }
        if (this.isClassPath()) {
            this.path = this.path.replace(".", "/");
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
        } else if (!this.isFileSystem()) {
            throw new CassandraMigrationException("Unknown prefix for location. Must be classpath: or filesystem:." + normalizedDescriptor);
        }
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    public boolean isClassPath() {
        return CLASSPATH_PREFIX.equals(this.prefix);
    }

    public boolean isFileSystem() {
        return FILESYSTEM_PREFIX.equals(this.prefix);
    }

    public boolean isParentOf(ScriptsLocation other) {
        return (other.getDescriptor() + "/").startsWith(this.getDescriptor() + "/");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescriptor() {
        return this.prefix + this.path;
    }

    @Override
    public int compareTo(ScriptsLocation o) {
        return this.getDescriptor().compareTo(o.getDescriptor());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptsLocation location = (ScriptsLocation)o;
        return this.getDescriptor().equals(location.getDescriptor());
    }

    public int hashCode() {
        return this.getDescriptor().hashCode();
    }

    public String toString() {
        return this.getDescriptor();
    }
}

