/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.config;

public class Cluster {
    private static final String PROPERTY_PREFIX = "cassandra.migration.cluster.";
    private String[] contactpoints = new String[]{"localhost"};
    private int port = 9042;
    private String username;
    private String password;

    public Cluster() {
        String passwordP;
        String usernameP;
        String portP;
        String contactpointsP = System.getProperty(ClusterProperty.CONTACTPOINTS.getName());
        if (null != contactpointsP && contactpointsP.trim().length() != 0) {
            this.contactpoints = contactpointsP.replaceAll("\\s+", "").split("[,]");
        }
        if (null != (portP = System.getProperty(ClusterProperty.PORT.getName())) && portP.trim().length() != 0) {
            this.port = Integer.parseInt(portP);
        }
        if (null != (usernameP = System.getProperty(ClusterProperty.USERNAME.getName())) && usernameP.trim().length() != 0) {
            this.username = usernameP;
        }
        if (null != (passwordP = System.getProperty(ClusterProperty.PASSWORD.getName())) && passwordP.trim().length() != 0) {
            this.password = passwordP;
        }
    }

    public String[] getContactpoints() {
        return this.contactpoints;
    }

    public void setContactpoints(String ... contactpoints) {
        this.contactpoints = contactpoints;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static enum ClusterProperty {
        CONTACTPOINTS("cassandra.migration.cluster.contactpoints", "Comma separated values of node IP addresses"),
        PORT("cassandra.migration.cluster.port", "CQL native transport port"),
        USERNAME("cassandra.migration.cluster.username", "Username for password authenticator"),
        PASSWORD("cassandra.migration.cluster.password", "Password for password authenticator");

        private String name;
        private String description;

        private ClusterProperty(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

