/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.mcs.V19;

import com.contrastsecurity.cassandra.migration.api.JavaMigration;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import java.util.Iterator;
import java.util.UUID;

public class V19_1__fix_invalid_data
implements JavaMigration {
    private static final Log LOG = LogFactory.getLog(V19_1__fix_invalid_data.class);
    private static final int DEFAULT_RETRIES = 3;
    private static final int RETRY_SLEEP_TIME = 5000;
    private static final int FETCH_SIZE = 1000;
    private static final String METIS_PROVIDER = "metis_production";
    private static final String METIS_TEST_PROVIDER = "metis_acceptance";
    private PreparedStatement datasetSelectValues;
    private PreparedStatement datasetDeleteRow;
    private PreparedStatement datasetInsertRow;

    private void initStatements(Session session) {
        this.datasetSelectValues = session.prepare("select provider_id, dataset_id, bucket_id, cloud_id, representation_id, revision_name, revision_provider, revision_timestamp, version_id, acceptance, published, mark_deleted from latest_dataset_representation_revision_v1;");
        this.datasetDeleteRow = session.prepare("delete from latest_dataset_representation_revision_v1 where provider_id = ? and dataset_id = ? and bucket_id = ?;");
        this.datasetInsertRow = session.prepare("insert into latest_dataset_representation_revision_v1 (provider_id, dataset_id,bucket_id,cloud_id,representation_id, revision_name, revision_provider, revision_timestamp,version_id, acceptance, published, mark_deleted) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
    }

    public void migrate(Session session) {
        this.initStatements(session);
        BoundStatement datasetValuesStatement = this.datasetSelectValues.bind();
        datasetValuesStatement.setFetchSize(1000);
        ResultSet resultSet = session.execute((Statement)datasetValuesStatement);
        Iterator iterator = resultSet.iterator();
        long totalCounter = 0L;
        long fixedCounter = 0L;
        boolean hasNext = iterator.hasNext();
        block4: while (hasNext) {
            if (++totalCounter % 100000L == 0L) {
                LOG.info("V19_1__fix_invalid_data is working; totalCounter = " + totalCounter);
            }
            Row row = (Row)iterator.next();
            String providerId = row.getString("provider_id");
            String datasetId = row.getString("dataset_id");
            UUID bucketId = row.getUUID("bucket_id");
            if (this.isRatherProviderId(providerId, datasetId)) {
                LOG.debug("Fixing item " + this.formatItemId(providerId, datasetId, bucketId));
                this.swapValues(session, row, providerId, datasetId, bucketId);
                ++fixedCounter;
            }
            int attempt = 3;
            while (true) {
                try {
                    do {
                        if (attempt < 1) {
                            hasNext = false;
                            continue block4;
                        }
                        --attempt;
                    } while (!(hasNext = iterator.hasNext()));
                    continue block4;
                }
                catch (ReadTimeoutException rte) {
                    LOG.info("totalCounter = " + totalCounter + "; fixedCounter = " + fixedCounter);
                    LOG.warn(rte.getMessage());
                    try {
                        LOG.info("Waiting 10s ...");
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }
        LOG.info("Fixing 'provider_id' <=> 'dataset_id' in 'latest_dataset_representation_revision_v1' finished. Total number of processed items: " + totalCounter + ". Fixed items: " + fixedCounter + ".");
    }

    private boolean isRatherProviderId(String providerId, String datasetId) {
        return datasetId.equals(METIS_PROVIDER) && !providerId.equals(METIS_PROVIDER) || datasetId.equals(METIS_TEST_PROVIDER) && !providerId.equals(METIS_TEST_PROVIDER);
    }

    private void swapValues(Session session, Row sourceRow, String providerId, String datasetId, UUID bucketId) {
        this.insertRow(session, sourceRow, providerId, datasetId, bucketId);
        this.deleteRow(session, providerId, datasetId, bucketId);
    }

    private void insertRow(Session session, Row sourceRow, String providerId, String datasetId, UUID bucketId) {
        BoundStatement datasetInsertRowStatement = this.datasetInsertRow.bind(new Object[]{datasetId, providerId, bucketId, sourceRow.getString("cloud_id"), sourceRow.getString("representation_id"), sourceRow.getString("revision_name"), sourceRow.getString("revision_provider"), sourceRow.getDate("revision_timestamp"), sourceRow.getUUID("version_id"), sourceRow.getBool("acceptance"), sourceRow.getBool("published"), sourceRow.getBool("mark_deleted")});
        this.executeStatementWithRetires(session, datasetInsertRowStatement, "inserting fixed data to 'latest_dataset_representation_revision_v1' table", this.formatItemId(providerId, datasetId, bucketId) + " in source row");
    }

    private void deleteRow(Session session, String providerId, String datasetId, UUID bucketId) {
        BoundStatement datasetDeleteRowStatement = this.datasetDeleteRow.bind(new Object[]{providerId, datasetId, bucketId});
        this.executeStatementWithRetires(session, datasetDeleteRowStatement, "deleting wrong data from 'latest_dataset_representation_revision_v1' table", this.formatItemId(providerId, datasetId, bucketId) + " in source row");
    }

    private void executeStatementWithRetires(Session session, BoundStatement statement, String message, String itemKey) {
        int retries = 3;
        while (true) {
            try {
                LOG.debug("Execute statement..." + statement.preparedStatement().getQueryString());
                session.execute((Statement)statement);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOG.warn("Warning while " + message + ". Retries left:" + retries);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        LOG.warn(e1.getMessage());
                    }
                    continue;
                }
                LOG.error("Error while " + message + ". Item: " + itemKey);
                throw e;
            }
            break;
        }
    }

    private String formatItemId(String providerId, String datasetId, UUID bucketId) {
        return String.format("(provider_id = %s, dataset_id = %s, bucket_id = %s)", providerId, datasetId, bucketId.toString());
    }
}

