/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.mcs.V18.jobs;

import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.eaio.uuid.UUID;
import eu.europeana.cloud.common.utils.Bucket;
import eu.europeana.cloud.service.commons.utils.BucketsHandler;
import java.util.Iterator;
import java.util.concurrent.Callable;
import migrations.common.TableCopier;

public class DataCopier
implements Callable<String> {
    private static final Log LOG = LogFactory.getLog(DataCopier.class);
    private static final String PROVIDER_ID = "provider_id";
    private static final String DATASET_ID = "dataset_id";
    private static final int DEFAULT_RETRIES = 3;
    private static final int SLEEP_TIME = 5000;
    private Session session;
    private PreparedStatement selectStatement;
    private PreparedStatement insertStatement;
    private PreparedStatement bucketsForSpecificObjectIdStatement;
    private PreparedStatement countOfRowsStatement;
    private static final int BUCKET_SIZE = 200000;
    private static final String CDSID_SEPARATOR = "\n";
    private static final String BUCKET_TABLE_NAME = "latest_dataset_representation_revision_buckets";
    private String providerId;
    private String dataSetId;

    public DataCopier(Session session, String provider_id, String dataset_id) {
        this.session = session;
        this.providerId = provider_id;
        this.dataSetId = dataset_id;
        this.initStatements();
    }

    private void initStatements() {
        this.selectStatement = this.session.prepare("SELECT * FROM latest_provider_dataset_rep_rev_replica where provider_id=? and dataset_id=?;");
        this.insertStatement = this.session.prepare("INSERT INTO latest_dataset_representation_revision_v1 (provider_id, dataset_id, bucket_id, cloud_id, representation_id, revision_timestamp, revision_name, revision_provider, version_id, acceptance, published, mark_deleted) VALUES (?,?,?,?,?,?,?,?,?,?,?,?);");
        this.bucketsForSpecificObjectIdStatement = this.session.prepare("Select bucket_id from latest_dataset_representation_revision_buckets where object_id=?");
        this.countOfRowsStatement = this.session.prepare("Select count(*) from latest_dataset_representation_revision_v1 where provider_id=? and dataset_id=? and bucket_id=? and representation_id=? and revision_name=? and revision_provider=? and mark_deleted=? and cloud_id=? ;");
        this.selectStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.insertStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.bucketsForSpecificObjectIdStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.countOfRowsStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
    }

    @Override
    public String call() throws Exception {
        BucketsHandler bucketsHandler = new BucketsHandler(this.session);
        long insertsCounter = 0L;
        long readsCounter = 0L;
        LOG.info("Starting job for providerId: " + this.providerId + " and datasetId " + this.dataSetId + " fthe current progress is: " + readsCounter);
        BoundStatement boundStatement = this.selectStatement.bind(new Object[]{this.providerId, this.dataSetId});
        boundStatement.setFetchSize(1000);
        ResultSet rs = this.session.execute((Statement)boundStatement);
        Iterator ri = rs.iterator();
        try {
            while (TableCopier.hasNextRow(ri)) {
                Row latestProviderDatasetReplica = (Row)ri.next();
                if (this.getRowCount(this.session, latestProviderDatasetReplica) == 0L) {
                    Bucket bucket = bucketsHandler.getCurrentBucket(BUCKET_TABLE_NAME, this.createProviderDataSetId(latestProviderDatasetReplica.getString(PROVIDER_ID), latestProviderDatasetReplica.getString(DATASET_ID)));
                    if (bucket == null || bucket.getRowsCount() >= 200000L) {
                        bucket = new Bucket(this.createProviderDataSetId(latestProviderDatasetReplica.getString(PROVIDER_ID), latestProviderDatasetReplica.getString(DATASET_ID)), new UUID().toString(), 0L);
                    }
                    bucketsHandler.increaseBucketCount(BUCKET_TABLE_NAME, bucket);
                    this.insertIntoNewTable(latestProviderDatasetReplica, bucket.getBucketId());
                    if (++insertsCounter % 10000L == 0L) {
                        LOG.info("Copy table for providerId: " + this.providerId + " and datasetId " + this.dataSetId + " the current progress for inserts is: " + insertsCounter);
                    }
                }
                if (++readsCounter % 10000L != 0L) continue;
                LOG.info("Copy table for providerId: " + this.providerId + " and datasetId " + this.dataSetId + " the current progress for reads is: " + readsCounter);
            }
        }
        catch (Exception e) {
            LOG.error("Migration failed providerId: " + this.providerId + " and datasetId " + this.dataSetId + ". Reads: " + readsCounter + ". Inserts: " + insertsCounter);
        }
        LOG.info("Finished job for providerId: " + this.providerId + " and datasetId " + this.dataSetId + ". Reads: " + readsCounter + ". Inserts: " + insertsCounter);
        return "................... The information for providerId: " + this.providerId + " and datasetId " + this.dataSetId + " is inserted correctly. The total number of inserted rows is:" + readsCounter;
    }

    private void insertIntoNewTable(Row row, String bucketId) {
        BoundStatement insert = this.insertStatement.bind(new Object[]{row.getString(PROVIDER_ID), row.getString(DATASET_ID), java.util.UUID.fromString(bucketId), row.getString("cloud_id"), row.getString("representation_id"), row.getDate("revision_timestamp"), row.getString("revision_name"), row.getString("revision_provider"), row.getUUID("version_id"), row.getBool("acceptance"), row.getBool("published"), row.getBool("mark_deleted")});
        int retries = 3;
        while (true) {
            try {
                this.session.execute((Statement)insert);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    System.out.println("Warning while inserting to latest_dataset_representation_revision_v1. Retries left:" + retries);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        System.err.println(e1.getMessage());
                    }
                    continue;
                }
                System.err.println("Error while inserting to latest_dataset_representation_revision_v1. " + insert.preparedStatement().getQueryString());
                throw e;
            }
            break;
        }
    }

    private long getRowCount(Session session, Row latestProviderDatasetReplica) {
        String objectId = this.createProviderDataSetId(latestProviderDatasetReplica.getString(PROVIDER_ID), latestProviderDatasetReplica.getString(DATASET_ID));
        BoundStatement boundStatement = this.bucketsForSpecificObjectIdStatement.bind(new Object[]{objectId});
        ResultSet rs = session.execute((Statement)boundStatement);
        Iterator ri = rs.iterator();
        while (TableCopier.hasNextRow(ri)) {
            java.util.UUID bucketId = ((Row)ri.next()).getUUID("bucket_id");
            BoundStatement countBoundStatement = this.countOfRowsStatement.bind(new Object[]{latestProviderDatasetReplica.getString(PROVIDER_ID), latestProviderDatasetReplica.getString(DATASET_ID), bucketId, latestProviderDatasetReplica.getString("representation_id"), latestProviderDatasetReplica.getString("revision_name"), latestProviderDatasetReplica.getString("revision_provider"), latestProviderDatasetReplica.getBool("mark_deleted"), latestProviderDatasetReplica.getString("cloud_id")});
            ResultSet resultSet = session.execute((Statement)countBoundStatement);
            long count = resultSet.one().getLong(0);
            if (count <= 0L) continue;
            return count;
        }
        return 0L;
    }

    private String createProviderDataSetId(String providerId, String dataSetId) {
        return providerId + CDSID_SEPARATOR + dataSetId;
    }
}

