/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.mcs.V17;

import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.Iterator;
import java.util.UUID;
import migrations.common.TableCopier;

class ValidationJob
implements Runnable {
    private static final Log LOG = LogFactory.getLog(ValidationJob.class);
    protected static final String CDSID_SEPARATOR = "\n";
    private static final int DEFAULT_RETRIES = 3;
    private static final int SLEEP_TIME = 5000;
    private Session session;
    private String provider_id;
    private String dataset_id;
    private PreparedStatement selectStatement;
    private PreparedStatement bucketsForSpecificObjectIdStatement;
    private PreparedStatement countOfRowsStatementFromV1;
    private PreparedStatement countOfRowsStatementFromReplica;

    private void initStatements(Session session) {
        this.selectStatement = session.prepare("SELECT * FROM latest_provider_dataset_representation_revision where provider_id = ? and dataset_id = ?");
        this.bucketsForSpecificObjectIdStatement = session.prepare("Select bucket_id from latest_dataset_representation_revision_buckets where object_id=?");
        this.countOfRowsStatementFromV1 = session.prepare("Select count(*) from latest_dataset_representation_revision_v1 where provider_id=? and dataset_id=? and bucket_id=? and representation_id=? and revision_name=? and revision_provider=? and mark_deleted=? and cloud_id=?;");
        this.countOfRowsStatementFromReplica = session.prepare("Select count(*) from latest_provider_dataset_rep_rev_replica where provider_id=? and dataset_id=? and representation_id=? and revision_name=? and revision_provider=? and mark_deleted=? and cloud_id=?;");
        this.selectStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.countOfRowsStatementFromV1.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.countOfRowsStatementFromReplica.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.bucketsForSpecificObjectIdStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
    }

    public ValidationJob(Session session, String provider_id, String dataset_id) {
        this.session = session;
        this.provider_id = provider_id;
        this.dataset_id = dataset_id;
    }

    @Override
    public void run() {
        try {
            LOG.info("Starting validation for for: " + this.provider_id + ":" + this.dataset_id);
            this.initStatements(this.session);
            long counter = 0L;
            BoundStatement boundStatement = this.selectStatement.bind(new Object[]{this.provider_id, this.dataset_id});
            boundStatement.setFetchSize(1000);
            ResultSet rs = this.session.execute((Statement)boundStatement);
            Iterator ri = rs.iterator();
            while (TableCopier.hasNextRow(ri)) {
                Row row = (Row)ri.next();
                this.matchRecord(this.session, row);
                if (++counter % 10000L != 0L) continue;
                LOG.info("validating table progress for: " + this.provider_id + ":" + this.dataset_id + "id =" + counter);
            }
            LOG.info("Validating finished successfully for: " + this.provider_id + ":" + this.dataset_id + ". Validated rows: " + counter);
        }
        catch (Exception e) {
            LOG.error("FAILED to execute Validation for: " + this.provider_id + ":" + this.dataset_id + "." + e.getMessage() + " . The cause of the problem: " + e.getCause());
        }
    }

    private String createProviderDataSetId(String providerId, String dataSetId) {
        return providerId + CDSID_SEPARATOR + dataSetId;
    }

    private void matchRecord(Session session, Row row) {
        String objectId = this.createProviderDataSetId(row.getString("provider_id"), row.getString("dataset_id"));
        BoundStatement boundStatement = this.bucketsForSpecificObjectIdStatement.bind(new Object[]{objectId});
        ResultSet rs = session.execute((Statement)boundStatement);
        Iterator ri = rs.iterator();
        while (TableCopier.hasNextRow(ri)) {
            UUID bucketId = ((Row)ri.next()).getUUID("bucket_id");
            long count = this.getMatchCount(row, bucketId, this.countOfRowsStatementFromV1);
            if (count <= 0L) continue;
            return;
        }
        long count = this.getMatchCountFromReplica(row, this.countOfRowsStatementFromReplica);
        if (count > 0L) {
            return;
        }
        throw new RuntimeException("The record with providerId= " + row.getString("provider_id") + " & datasetId=" + row.getString("dataset_id") + " & revision_name=" + row.getString("revision_name") + " & cloud_id=" + row.getString("cloud_id") + " couldn't be validated");
    }

    private long getMatchCount(Row row, UUID bucketId, PreparedStatement countOfRowsStatement) {
        BoundStatement countBoundStatement = countOfRowsStatement.bind(new Object[]{row.getString("provider_id"), row.getString("dataset_id"), bucketId, row.getString("representation_id"), row.getString("revision_name"), row.getString("revision_provider"), row.getBool("mark_deleted"), row.getString("cloud_id")});
        int retries = 3;
        while (true) {
            try {
                ResultSet resultSet = this.session.execute((Statement)countBoundStatement);
                return resultSet.one().getLong(0);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOG.warn("Warning while matching record to latest_provider_dataset_representation_revision. Retries left:" + retries);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        System.err.println(e1.getMessage());
                    }
                    continue;
                }
                LOG.error("Error while matching record for latest_provider_dataset_representation_revision. " + countBoundStatement.preparedStatement().getQueryString());
                throw e;
            }
            break;
        }
    }

    private long getMatchCountFromReplica(Row row, PreparedStatement countOfRowsStatement) {
        BoundStatement countBoundStatement = countOfRowsStatement.bind(new Object[]{row.getString("provider_id"), row.getString("dataset_id"), row.getString("representation_id"), row.getString("revision_name"), row.getString("revision_provider"), row.getBool("mark_deleted"), row.getString("cloud_id")});
        int retries = 3;
        while (true) {
            try {
                ResultSet resultSet = this.session.execute((Statement)countBoundStatement);
                return resultSet.one().getLong(0);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOG.warn("Warning while matching record from latest_provider_dataset_representation_revision to replica. Retries left:" + retries);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        System.err.println(e1.getMessage());
                    }
                    continue;
                }
                LOG.error("Error while matching record from latest_provider_dataset_representation_revision to replica. " + countBoundStatement.preparedStatement().getQueryString());
                throw e;
            }
            break;
        }
    }
}

