/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;
import org.springframework.security.authentication.CachingUserDetailsService;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.StringUtils;

public class UserDetailsServiceFactoryBean
implements ApplicationContextAware {
    private ApplicationContext beanFactory;

    UserDetailsService userDetailsService(String id) {
        if (!StringUtils.hasText(id)) {
            return this.getUserDetailsService();
        }
        return (UserDetailsService)this.beanFactory.getBean(id);
    }

    UserDetailsService cachingUserDetailsService(String id) {
        if (!StringUtils.hasText(id)) {
            return this.getUserDetailsService();
        }
        String cachingId = id + ".caching";
        if (this.beanFactory.containsBeanDefinition(cachingId)) {
            return (UserDetailsService)this.beanFactory.getBean(cachingId);
        }
        return (UserDetailsService)this.beanFactory.getBean(id);
    }

    AuthenticationUserDetailsService authenticationUserDetailsService(String name) {
        UserDetailsService uds;
        if (!StringUtils.hasText(name)) {
            Map<String, ?> beans2 = this.getBeansOfType(AuthenticationUserDetailsService.class);
            if (!beans2.isEmpty()) {
                if (beans2.size() > 1) {
                    throw new ApplicationContextException("More than one AuthenticationUserDetailsService registered. Please use a specific Id reference.");
                }
                return (AuthenticationUserDetailsService)beans2.values().toArray()[0];
            }
            uds = this.getUserDetailsService();
        } else {
            Object bean2 = this.beanFactory.getBean(name);
            if (bean2 instanceof AuthenticationUserDetailsService) {
                return (AuthenticationUserDetailsService)bean2;
            }
            if (bean2 instanceof UserDetailsService) {
                uds = this.cachingUserDetailsService(name);
                if (uds == null) {
                    uds = (UserDetailsService)bean2;
                }
            } else {
                throw new ApplicationContextException("Bean '" + name + "' must be a UserDetailsService or an AuthenticationUserDetailsService");
            }
        }
        return new UserDetailsByNameServiceWrapper(uds);
    }

    private UserDetailsService getUserDetailsService() {
        Map<String, ?> beans2 = this.getBeansOfType(CachingUserDetailsService.class);
        if (beans2.size() == 0) {
            beans2 = this.getBeansOfType(UserDetailsService.class);
        }
        if (beans2.size() == 0) {
            throw new ApplicationContextException("No UserDetailsService registered.");
        }
        if (beans2.size() > 1) {
            throw new ApplicationContextException("More than one UserDetailsService registered. Please use a specific Id reference in <remember-me/> <openid-login/> or <x509 /> elements.");
        }
        return (UserDetailsService)beans2.values().toArray()[0];
    }

    @Override
    public void setApplicationContext(ApplicationContext beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private Map<String, ?> getBeansOfType(Class<?> type) {
        Map<String, ?> beans2 = this.beanFactory.getBeansOfType(type);
        BeanFactory parent = this.beanFactory.getParentBeanFactory();
        while (parent != null && beans2.size() == 0) {
            if (parent instanceof ListableBeanFactory) {
                beans2 = ((ListableBeanFactory)parent).getBeansOfType(type);
            }
            if (!(parent instanceof HierarchicalBeanFactory)) break;
            parent = ((HierarchicalBeanFactory)parent).getParentBeanFactory();
        }
        return beans2;
    }
}

