/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.config.http.FormLoginBeanDefinitionParser;
import org.springframework.security.config.http.LogoutBeanDefinitionParser;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.RememberMeBeanDefinitionParser;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.config.http.UserDetailsServiceFactoryBean;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleMappableAttributesRetriever;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.security.web.authentication.preauth.j2ee.J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultLogoutPageGeneratingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

final class AuthenticationConfigBuilder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_REALM = "realm";
    private static final String DEF_REALM = "Realm";
    static final String OPEN_ID_AUTHENTICATION_PROCESSING_FILTER_CLASS = "org.springframework.security.openid.OpenIDAuthenticationFilter";
    static final String OPEN_ID_AUTHENTICATION_PROVIDER_CLASS = "org.springframework.security.openid.OpenIDAuthenticationProvider";
    private static final String OPEN_ID_CONSUMER_CLASS = "org.springframework.security.openid.OpenID4JavaConsumer";
    static final String OPEN_ID_ATTRIBUTE_CLASS = "org.springframework.security.openid.OpenIDAttribute";
    private static final String OPEN_ID_ATTRIBUTE_FACTORY_CLASS = "org.springframework.security.openid.RegexBasedAxFetchListFactory";
    static final String AUTHENTICATION_PROCESSING_FILTER_CLASS = "org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter";
    static final String ATT_AUTH_DETAILS_SOURCE_REF = "authentication-details-source-ref";
    private static final String ATT_AUTO_CONFIG = "auto-config";
    private static final String ATT_ACCESS_DENIED_ERROR_PAGE = "error-page";
    private static final String ATT_ENTRY_POINT_REF = "entry-point-ref";
    private static final String ATT_USER_SERVICE_REF = "user-service-ref";
    private static final String ATT_KEY = "key";
    private final Element httpElt;
    private final ParserContext pc;
    private final boolean autoConfig;
    private final boolean allowSessionCreation;
    private RootBeanDefinition anonymousFilter;
    private BeanReference anonymousProviderRef;
    private BeanDefinition rememberMeFilter;
    private String rememberMeServicesId;
    private BeanReference rememberMeProviderRef;
    private BeanDefinition basicFilter;
    private RuntimeBeanReference basicEntryPoint;
    private BeanDefinition formEntryPoint;
    private BeanDefinition openIDEntryPoint;
    private BeanReference openIDProviderRef;
    private String formFilterId = null;
    private String openIDFilterId = null;
    private BeanDefinition x509Filter;
    private BeanReference x509ProviderRef;
    private BeanDefinition jeeFilter;
    private BeanReference jeeProviderRef;
    private RootBeanDefinition preAuthEntryPoint;
    private BeanMetadataElement mainEntryPoint;
    private BeanMetadataElement accessDeniedHandler;
    private BeanDefinition logoutFilter;
    private ManagedList logoutHandlers;
    private BeanDefinition loginPageGenerationFilter;
    private BeanDefinition logoutPageGenerationFilter;
    private BeanDefinition etf;
    private final BeanReference requestCache;
    private final BeanReference portMapper;
    private final BeanReference portResolver;
    private final BeanMetadataElement csrfLogoutHandler;
    private String loginProcessingUrl;
    private String openidLoginProcessingUrl;
    private String formLoginPage;
    private String openIDLoginPage;

    AuthenticationConfigBuilder(Element element, boolean forceAutoConfig, ParserContext pc, SessionCreationPolicy sessionPolicy, BeanReference requestCache, BeanReference authenticationManager, BeanReference sessionStrategy, BeanReference portMapper, BeanReference portResolver, BeanMetadataElement csrfLogoutHandler) {
        this.httpElt = element;
        this.pc = pc;
        this.requestCache = requestCache;
        this.autoConfig = forceAutoConfig | "true".equals(element.getAttribute(ATT_AUTO_CONFIG));
        this.allowSessionCreation = sessionPolicy != SessionCreationPolicy.NEVER && sessionPolicy != SessionCreationPolicy.STATELESS;
        this.portMapper = portMapper;
        this.portResolver = portResolver;
        this.csrfLogoutHandler = csrfLogoutHandler;
        this.createAnonymousFilter();
        this.createRememberMeFilter(authenticationManager);
        this.createBasicFilter(authenticationManager);
        this.createFormLoginFilter(sessionStrategy, authenticationManager);
        this.createOpenIDLoginFilter(sessionStrategy, authenticationManager);
        this.createX509Filter(authenticationManager);
        this.createJeeFilter(authenticationManager);
        this.createLogoutFilter();
        this.createLoginPageFilterIfNeeded();
        this.createUserDetailsServiceFactory();
        this.createExceptionTranslationFilter();
    }

    void createRememberMeFilter(BeanReference authenticationManager) {
        Element rememberMeElt = DomUtils.getChildElementByTagName(this.httpElt, "remember-me");
        if (rememberMeElt != null) {
            String key = rememberMeElt.getAttribute(ATT_KEY);
            if (!StringUtils.hasText(key)) {
                key = this.createKey();
            }
            RememberMeBeanDefinitionParser rememberMeParser = new RememberMeBeanDefinitionParser(key, authenticationManager);
            this.rememberMeFilter = rememberMeParser.parse(rememberMeElt, this.pc);
            this.rememberMeServicesId = rememberMeParser.getRememberMeServicesId();
            this.createRememberMeProvider(key);
        }
    }

    private void createRememberMeProvider(String key) {
        RootBeanDefinition provider = new RootBeanDefinition(RememberMeAuthenticationProvider.class);
        provider.setSource(this.rememberMeFilter.getSource());
        provider.getConstructorArgumentValues().addGenericArgumentValue(key);
        String id = this.pc.getReaderContext().generateBeanName(provider);
        this.pc.registerBeanComponent(new BeanComponentDefinition(provider, id));
        this.rememberMeProviderRef = new RuntimeBeanReference(id);
    }

    void createFormLoginFilter(BeanReference sessionStrategy, BeanReference authManager) {
        Element formLoginElt = DomUtils.getChildElementByTagName(this.httpElt, "form-login");
        AbstractBeanDefinition formFilter = null;
        if (formLoginElt != null || this.autoConfig) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/login", "POST", AUTHENTICATION_PROCESSING_FILTER_CLASS, this.requestCache, sessionStrategy, this.allowSessionCreation, this.portMapper, this.portResolver);
            parser.parse(formLoginElt, this.pc);
            formFilter = parser.getFilterBean();
            this.formEntryPoint = parser.getEntryPointBean();
            this.loginProcessingUrl = parser.getLoginProcessingUrl();
            this.formLoginPage = parser.getLoginPage();
        }
        if (formFilter != null) {
            formFilter.getPropertyValues().addPropertyValue("allowSessionCreation", this.allowSessionCreation);
            formFilter.getPropertyValues().addPropertyValue("authenticationManager", authManager);
            this.formFilterId = this.pc.getReaderContext().generateBeanName(formFilter);
            this.pc.registerBeanComponent(new BeanComponentDefinition(formFilter, this.formFilterId));
            this.injectRememberMeServicesRef((RootBeanDefinition)formFilter, this.rememberMeServicesId);
        }
    }

    void createOpenIDLoginFilter(BeanReference sessionStrategy, BeanReference authManager) {
        Element openIDLoginElt = DomUtils.getChildElementByTagName(this.httpElt, "openid-login");
        AbstractBeanDefinition openIDFilter = null;
        if (openIDLoginElt != null) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/login/openid", null, OPEN_ID_AUTHENTICATION_PROCESSING_FILTER_CLASS, this.requestCache, sessionStrategy, this.allowSessionCreation, this.portMapper, this.portResolver);
            parser.parse(openIDLoginElt, this.pc);
            openIDFilter = parser.getFilterBean();
            this.openIDEntryPoint = parser.getEntryPointBean();
            this.openidLoginProcessingUrl = parser.getLoginProcessingUrl();
            this.openIDLoginPage = parser.getLoginPage();
            List<Element> attrExElts = DomUtils.getChildElementsByTagName(openIDLoginElt, "attribute-exchange");
            if (!attrExElts.isEmpty()) {
                BeanDefinitionBuilder consumerBldr = BeanDefinitionBuilder.rootBeanDefinition(OPEN_ID_CONSUMER_CLASS);
                BeanDefinitionBuilder axFactory = BeanDefinitionBuilder.rootBeanDefinition(OPEN_ID_ATTRIBUTE_FACTORY_CLASS);
                ManagedMap<String, ManagedList<BeanDefinition>> axMap = new ManagedMap<String, ManagedList<BeanDefinition>>();
                for (Element attrExElt : attrExElts) {
                    String identifierMatch = attrExElt.getAttribute("identifier-match");
                    if (!StringUtils.hasText(identifierMatch)) {
                        if (attrExElts.size() > 1) {
                            this.pc.getReaderContext().error("You must supply an identifier-match attribute if using more than one attribute-exchange element", attrExElt);
                        }
                        identifierMatch = ".*";
                    }
                    axMap.put(identifierMatch, this.parseOpenIDAttributes(attrExElt));
                }
                axFactory.addConstructorArgValue(axMap);
                consumerBldr.addConstructorArgValue(axFactory.getBeanDefinition());
                openIDFilter.getPropertyValues().addPropertyValue("consumer", consumerBldr.getBeanDefinition());
            }
        }
        if (openIDFilter != null) {
            openIDFilter.getPropertyValues().addPropertyValue("allowSessionCreation", this.allowSessionCreation);
            openIDFilter.getPropertyValues().addPropertyValue("authenticationManager", authManager);
            this.openIDFilterId = this.pc.getReaderContext().generateBeanName(openIDFilter);
            this.pc.registerBeanComponent(new BeanComponentDefinition(openIDFilter, this.openIDFilterId));
            this.injectRememberMeServicesRef((RootBeanDefinition)openIDFilter, this.rememberMeServicesId);
            this.createOpenIDProvider();
        }
    }

    private ManagedList<BeanDefinition> parseOpenIDAttributes(Element attrExElt) {
        ManagedList<BeanDefinition> attributes = new ManagedList<BeanDefinition>();
        for (Element attElt : DomUtils.getChildElementsByTagName(attrExElt, "openid-attribute")) {
            String name = attElt.getAttribute("name");
            String type = attElt.getAttribute("type");
            String required = attElt.getAttribute("required");
            String count = attElt.getAttribute("count");
            BeanDefinitionBuilder attrBldr = BeanDefinitionBuilder.rootBeanDefinition(OPEN_ID_ATTRIBUTE_CLASS);
            attrBldr.addConstructorArgValue(name);
            attrBldr.addConstructorArgValue(type);
            if (StringUtils.hasLength(required)) {
                attrBldr.addPropertyValue("required", Boolean.valueOf(required));
            }
            if (StringUtils.hasLength(count)) {
                attrBldr.addPropertyValue("count", Integer.parseInt(count));
            }
            attributes.add(attrBldr.getBeanDefinition());
        }
        return attributes;
    }

    private void createOpenIDProvider() {
        Element openIDLoginElt = DomUtils.getChildElementByTagName(this.httpElt, "openid-login");
        BeanDefinitionBuilder openIDProviderBuilder = BeanDefinitionBuilder.rootBeanDefinition(OPEN_ID_AUTHENTICATION_PROVIDER_CLASS);
        RootBeanDefinition uds = new RootBeanDefinition();
        uds.setFactoryBeanName("org.springframework.security.userDetailsServiceFactory");
        uds.setFactoryMethodName("authenticationUserDetailsService");
        uds.getConstructorArgumentValues().addGenericArgumentValue(openIDLoginElt.getAttribute(ATT_USER_SERVICE_REF));
        openIDProviderBuilder.addPropertyValue("authenticationUserDetailsService", uds);
        AbstractBeanDefinition openIDProvider = openIDProviderBuilder.getBeanDefinition();
        this.openIDProviderRef = new RuntimeBeanReference(this.pc.getReaderContext().registerWithGeneratedName(openIDProvider));
    }

    private void injectRememberMeServicesRef(RootBeanDefinition bean2, String rememberMeServicesId) {
        if (rememberMeServicesId != null) {
            bean2.getPropertyValues().addPropertyValue("rememberMeServices", new RuntimeBeanReference(rememberMeServicesId));
        }
    }

    void createBasicFilter(BeanReference authManager) {
        Element basicAuthElt = DomUtils.getChildElementByTagName(this.httpElt, "http-basic");
        if (basicAuthElt == null && !this.autoConfig) {
            return;
        }
        String realm = this.httpElt.getAttribute(ATT_REALM);
        if (!StringUtils.hasText(realm)) {
            realm = DEF_REALM;
        }
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(BasicAuthenticationFilter.class);
        if (basicAuthElt != null) {
            if (StringUtils.hasText(basicAuthElt.getAttribute(ATT_ENTRY_POINT_REF))) {
                this.basicEntryPoint = new RuntimeBeanReference(basicAuthElt.getAttribute(ATT_ENTRY_POINT_REF));
            }
            this.injectAuthenticationDetailsSource(basicAuthElt, filterBuilder);
        }
        if (this.basicEntryPoint == null) {
            RootBeanDefinition entryPoint = new RootBeanDefinition(BasicAuthenticationEntryPoint.class);
            entryPoint.setSource(this.pc.extractSource(this.httpElt));
            entryPoint.getPropertyValues().addPropertyValue("realmName", realm);
            String entryPointId = this.pc.getReaderContext().generateBeanName(entryPoint);
            this.pc.registerBeanComponent(new BeanComponentDefinition(entryPoint, entryPointId));
            this.basicEntryPoint = new RuntimeBeanReference(entryPointId);
        }
        filterBuilder.addConstructorArgValue(authManager);
        filterBuilder.addConstructorArgValue(this.basicEntryPoint);
        this.basicFilter = filterBuilder.getBeanDefinition();
    }

    void createX509Filter(BeanReference authManager) {
        Element x509Elt = DomUtils.getChildElementByTagName(this.httpElt, "x509");
        RootBeanDefinition filter = null;
        if (x509Elt != null) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(X509AuthenticationFilter.class);
            filterBuilder.getRawBeanDefinition().setSource(this.pc.extractSource(x509Elt));
            filterBuilder.addPropertyValue("authenticationManager", authManager);
            String regex = x509Elt.getAttribute("subject-principal-regex");
            if (StringUtils.hasText(regex)) {
                BeanDefinitionBuilder extractor = BeanDefinitionBuilder.rootBeanDefinition(SubjectDnX509PrincipalExtractor.class);
                extractor.addPropertyValue("subjectDnRegex", regex);
                filterBuilder.addPropertyValue("principalExtractor", extractor.getBeanDefinition());
            }
            this.injectAuthenticationDetailsSource(x509Elt, filterBuilder);
            filter = (RootBeanDefinition)filterBuilder.getBeanDefinition();
            this.createPrauthEntryPoint(x509Elt);
            this.createX509Provider();
        }
        this.x509Filter = filter;
    }

    private void injectAuthenticationDetailsSource(Element elt, BeanDefinitionBuilder filterBuilder) {
        String authDetailsSourceRef = elt.getAttribute(ATT_AUTH_DETAILS_SOURCE_REF);
        if (StringUtils.hasText(authDetailsSourceRef)) {
            filterBuilder.addPropertyReference("authenticationDetailsSource", authDetailsSourceRef);
        }
    }

    private void createX509Provider() {
        Element x509Elt = DomUtils.getChildElementByTagName(this.httpElt, "x509");
        RootBeanDefinition provider = new RootBeanDefinition(PreAuthenticatedAuthenticationProvider.class);
        RootBeanDefinition uds = new RootBeanDefinition();
        uds.setFactoryBeanName("org.springframework.security.userDetailsServiceFactory");
        uds.setFactoryMethodName("authenticationUserDetailsService");
        uds.getConstructorArgumentValues().addGenericArgumentValue(x509Elt.getAttribute(ATT_USER_SERVICE_REF));
        provider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", uds);
        this.x509ProviderRef = new RuntimeBeanReference(this.pc.getReaderContext().registerWithGeneratedName(provider));
    }

    private void createPrauthEntryPoint(Element source) {
        if (this.preAuthEntryPoint == null) {
            this.preAuthEntryPoint = new RootBeanDefinition(Http403ForbiddenEntryPoint.class);
            this.preAuthEntryPoint.setSource(this.pc.extractSource(source));
        }
    }

    void createJeeFilter(BeanReference authManager) {
        String ATT_MAPPABLE_ROLES = "mappable-roles";
        Element jeeElt = DomUtils.getChildElementByTagName(this.httpElt, "jee");
        RootBeanDefinition filter = null;
        if (jeeElt != null) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(J2eePreAuthenticatedProcessingFilter.class);
            filterBuilder.getRawBeanDefinition().setSource(this.pc.extractSource(jeeElt));
            filterBuilder.addPropertyValue("authenticationManager", authManager);
            BeanDefinitionBuilder adsBldr = BeanDefinitionBuilder.rootBeanDefinition(J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource.class);
            adsBldr.addPropertyValue("userRoles2GrantedAuthoritiesMapper", new RootBeanDefinition(SimpleAttributes2GrantedAuthoritiesMapper.class));
            String roles = jeeElt.getAttribute("mappable-roles");
            Assert.hasLength(roles, "roles is expected to have length");
            BeanDefinitionBuilder rolesBuilder = BeanDefinitionBuilder.rootBeanDefinition(StringUtils.class);
            rolesBuilder.addConstructorArgValue(roles);
            rolesBuilder.setFactoryMethod("commaDelimitedListToSet");
            RootBeanDefinition mappableRolesRetriever = new RootBeanDefinition(SimpleMappableAttributesRetriever.class);
            mappableRolesRetriever.getPropertyValues().addPropertyValue("mappableAttributes", rolesBuilder.getBeanDefinition());
            adsBldr.addPropertyValue("mappableRolesRetriever", mappableRolesRetriever);
            filterBuilder.addPropertyValue("authenticationDetailsSource", adsBldr.getBeanDefinition());
            filter = (RootBeanDefinition)filterBuilder.getBeanDefinition();
            this.createPrauthEntryPoint(jeeElt);
            this.createJeeProvider();
        }
        this.jeeFilter = filter;
    }

    private void createJeeProvider() {
        RootBeanDefinition uds;
        Element jeeElt = DomUtils.getChildElementByTagName(this.httpElt, "jee");
        RootBeanDefinition provider = new RootBeanDefinition(PreAuthenticatedAuthenticationProvider.class);
        if (StringUtils.hasText(jeeElt.getAttribute(ATT_USER_SERVICE_REF))) {
            uds = new RootBeanDefinition();
            uds.setFactoryBeanName("org.springframework.security.userDetailsServiceFactory");
            uds.setFactoryMethodName("authenticationUserDetailsService");
            uds.getConstructorArgumentValues().addGenericArgumentValue(jeeElt.getAttribute(ATT_USER_SERVICE_REF));
        } else {
            uds = new RootBeanDefinition(PreAuthenticatedGrantedAuthoritiesUserDetailsService.class);
        }
        provider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", uds);
        this.jeeProviderRef = new RuntimeBeanReference(this.pc.getReaderContext().registerWithGeneratedName(provider));
    }

    void createLoginPageFilterIfNeeded() {
        boolean needLoginPage;
        boolean bl = needLoginPage = this.formFilterId != null || this.openIDFilterId != null;
        if (needLoginPage && this.formLoginPage == null && this.openIDLoginPage == null) {
            this.logger.info("No login page configured. The default internal one will be used. Use the 'login-page' attribute to set the URL of the login page.");
            BeanDefinitionBuilder loginPageFilter = BeanDefinitionBuilder.rootBeanDefinition(DefaultLoginPageGeneratingFilter.class);
            loginPageFilter.addPropertyValue("resolveHiddenInputs", new CsrfTokenHiddenInputFunction());
            BeanDefinitionBuilder logoutPageFilter = BeanDefinitionBuilder.rootBeanDefinition(DefaultLogoutPageGeneratingFilter.class);
            logoutPageFilter.addPropertyValue("resolveHiddenInputs", new CsrfTokenHiddenInputFunction());
            if (this.formFilterId != null) {
                loginPageFilter.addConstructorArgReference(this.formFilterId);
                loginPageFilter.addPropertyValue("authenticationUrl", this.loginProcessingUrl);
            }
            if (this.openIDFilterId != null) {
                loginPageFilter.addConstructorArgReference(this.openIDFilterId);
                loginPageFilter.addPropertyValue("openIDauthenticationUrl", this.openidLoginProcessingUrl);
            }
            this.loginPageGenerationFilter = loginPageFilter.getBeanDefinition();
            this.logoutPageGenerationFilter = logoutPageFilter.getBeanDefinition();
        }
    }

    void createLogoutFilter() {
        Element logoutElt = DomUtils.getChildElementByTagName(this.httpElt, "logout");
        if (logoutElt != null || this.autoConfig) {
            String formLoginPage = this.formLoginPage;
            if (formLoginPage == null) {
                formLoginPage = "/login";
            }
            LogoutBeanDefinitionParser logoutParser = new LogoutBeanDefinitionParser(formLoginPage, this.rememberMeServicesId, this.csrfLogoutHandler);
            this.logoutFilter = logoutParser.parse(logoutElt, this.pc);
            this.logoutHandlers = logoutParser.getLogoutHandlers();
        }
    }

    ManagedList getLogoutHandlers() {
        if (this.logoutHandlers == null && this.rememberMeProviderRef != null) {
            this.logoutHandlers = new ManagedList();
            if (this.csrfLogoutHandler != null) {
                this.logoutHandlers.add(this.csrfLogoutHandler);
            }
            this.logoutHandlers.add(new RuntimeBeanReference(this.rememberMeServicesId));
            this.logoutHandlers.add(new RootBeanDefinition(SecurityContextLogoutHandler.class));
        }
        return this.logoutHandlers;
    }

    BeanMetadataElement getEntryPointBean() {
        return this.mainEntryPoint;
    }

    BeanMetadataElement getAccessDeniedHandlerBean() {
        return this.accessDeniedHandler;
    }

    void createAnonymousFilter() {
        Element anonymousElt = DomUtils.getChildElementByTagName(this.httpElt, "anonymous");
        if (anonymousElt != null && "false".equals(anonymousElt.getAttribute("enabled"))) {
            return;
        }
        String grantedAuthority = null;
        String username = null;
        String key = null;
        Object source = this.pc.extractSource(this.httpElt);
        if (anonymousElt != null) {
            grantedAuthority = anonymousElt.getAttribute("granted-authority");
            username = anonymousElt.getAttribute("username");
            key = anonymousElt.getAttribute(ATT_KEY);
            source = this.pc.extractSource(anonymousElt);
        }
        if (!StringUtils.hasText(grantedAuthority)) {
            grantedAuthority = "ROLE_ANONYMOUS";
        }
        if (!StringUtils.hasText(username)) {
            username = "anonymousUser";
        }
        if (!StringUtils.hasText(key)) {
            key = this.createKey();
        }
        this.anonymousFilter = new RootBeanDefinition(AnonymousAuthenticationFilter.class);
        this.anonymousFilter.getConstructorArgumentValues().addIndexedArgumentValue(0, key);
        this.anonymousFilter.getConstructorArgumentValues().addIndexedArgumentValue(1, username);
        this.anonymousFilter.getConstructorArgumentValues().addIndexedArgumentValue(2, AuthorityUtils.commaSeparatedStringToAuthorityList(grantedAuthority));
        this.anonymousFilter.setSource(source);
        RootBeanDefinition anonymousProviderBean = new RootBeanDefinition(AnonymousAuthenticationProvider.class);
        anonymousProviderBean.getConstructorArgumentValues().addIndexedArgumentValue(0, key);
        anonymousProviderBean.setSource(this.anonymousFilter.getSource());
        String id = this.pc.getReaderContext().generateBeanName(anonymousProviderBean);
        this.pc.registerBeanComponent(new BeanComponentDefinition(anonymousProviderBean, id));
        this.anonymousProviderRef = new RuntimeBeanReference(id);
    }

    private String createKey() {
        SecureRandom random = new SecureRandom();
        return Long.toString(random.nextLong());
    }

    void createExceptionTranslationFilter() {
        BeanDefinitionBuilder etfBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExceptionTranslationFilter.class);
        this.accessDeniedHandler = this.createAccessDeniedHandler(this.httpElt, this.pc);
        etfBuilder.addPropertyValue("accessDeniedHandler", this.accessDeniedHandler);
        assert (this.requestCache != null);
        this.mainEntryPoint = this.selectEntryPoint();
        etfBuilder.addConstructorArgValue(this.mainEntryPoint);
        etfBuilder.addConstructorArgValue(this.requestCache);
        this.etf = etfBuilder.getBeanDefinition();
    }

    private BeanMetadataElement createAccessDeniedHandler(Element element, ParserContext pc) {
        Element accessDeniedElt = DomUtils.getChildElementByTagName(element, "access-denied-handler");
        BeanDefinitionBuilder accessDeniedHandler = BeanDefinitionBuilder.rootBeanDefinition(AccessDeniedHandlerImpl.class);
        if (accessDeniedElt != null) {
            String errorPage = accessDeniedElt.getAttribute(ATT_ACCESS_DENIED_ERROR_PAGE);
            String ref = accessDeniedElt.getAttribute("ref");
            if (StringUtils.hasText(errorPage)) {
                if (StringUtils.hasText(ref)) {
                    pc.getReaderContext().error("The attribute error-page cannot be used together with the 'ref' attribute within <access-denied-handler>", pc.extractSource(accessDeniedElt));
                }
                accessDeniedHandler.addPropertyValue("errorPage", errorPage);
            } else if (StringUtils.hasText(ref)) {
                return new RuntimeBeanReference(ref);
            }
        }
        return accessDeniedHandler.getBeanDefinition();
    }

    private BeanMetadataElement selectEntryPoint() {
        String customEntryPoint = this.httpElt.getAttribute(ATT_ENTRY_POINT_REF);
        if (StringUtils.hasText(customEntryPoint)) {
            return new RuntimeBeanReference(customEntryPoint);
        }
        Element basicAuthElt = DomUtils.getChildElementByTagName(this.httpElt, "http-basic");
        Element formLoginElt = DomUtils.getChildElementByTagName(this.httpElt, "form-login");
        Element openIDLoginElt = DomUtils.getChildElementByTagName(this.httpElt, "openid-login");
        if (basicAuthElt != null && formLoginElt == null && openIDLoginElt == null) {
            return this.basicEntryPoint;
        }
        if (this.formLoginPage != null && this.openIDLoginPage != null) {
            this.pc.getReaderContext().error("Only one login-page can be defined, either for OpenID or form-login, but not both.", this.pc.extractSource(openIDLoginElt));
        }
        if (this.formFilterId != null && this.openIDLoginPage == null) {
            return this.formEntryPoint;
        }
        if (this.openIDFilterId != null) {
            return this.openIDEntryPoint;
        }
        if (this.preAuthEntryPoint != null) {
            return this.preAuthEntryPoint;
        }
        this.pc.getReaderContext().error("No AuthenticationEntryPoint could be established. Please make sure you have a login mechanism configured through the namespace (such as form-login) or specify a custom AuthenticationEntryPoint with the 'entry-point-ref' attribute ", this.pc.extractSource(this.httpElt));
        return null;
    }

    private void createUserDetailsServiceFactory() {
        if (this.pc.getRegistry().containsBeanDefinition("org.springframework.security.userDetailsServiceFactory")) {
            return;
        }
        RootBeanDefinition bean2 = new RootBeanDefinition(UserDetailsServiceFactoryBean.class);
        bean2.setRole(2);
        this.pc.registerBeanComponent(new BeanComponentDefinition(bean2, "org.springframework.security.userDetailsServiceFactory"));
    }

    List<OrderDecorator> getFilters() {
        ArrayList<OrderDecorator> filters = new ArrayList<OrderDecorator>();
        if (this.anonymousFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.anonymousFilter, SecurityFilters.ANONYMOUS_FILTER));
        }
        if (this.rememberMeFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.rememberMeFilter, SecurityFilters.REMEMBER_ME_FILTER));
        }
        if (this.logoutFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.logoutFilter, SecurityFilters.LOGOUT_FILTER));
        }
        if (this.x509Filter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.x509Filter, SecurityFilters.X509_FILTER));
        }
        if (this.jeeFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.jeeFilter, SecurityFilters.PRE_AUTH_FILTER));
        }
        if (this.formFilterId != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.formFilterId), SecurityFilters.FORM_LOGIN_FILTER));
        }
        if (this.openIDFilterId != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.openIDFilterId), SecurityFilters.OPENID_FILTER));
        }
        if (this.loginPageGenerationFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.loginPageGenerationFilter, SecurityFilters.LOGIN_PAGE_FILTER));
            filters.add(new OrderDecorator((BeanMetadataElement)this.logoutPageGenerationFilter, SecurityFilters.LOGOUT_PAGE_FILTER));
        }
        if (this.basicFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.basicFilter, SecurityFilters.BASIC_AUTH_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.etf, SecurityFilters.EXCEPTION_TRANSLATION_FILTER));
        return filters;
    }

    List<BeanReference> getProviders() {
        ArrayList<BeanReference> providers = new ArrayList<BeanReference>();
        if (this.anonymousProviderRef != null) {
            providers.add(this.anonymousProviderRef);
        }
        if (this.rememberMeProviderRef != null) {
            providers.add(this.rememberMeProviderRef);
        }
        if (this.openIDProviderRef != null) {
            providers.add(this.openIDProviderRef);
        }
        if (this.x509ProviderRef != null) {
            providers.add(this.x509ProviderRef);
        }
        if (this.jeeProviderRef != null) {
            providers.add(this.jeeProviderRef);
        }
        return providers;
    }

    private static class CsrfTokenHiddenInputFunction
    implements Function<HttpServletRequest, Map<String, String>> {
        private CsrfTokenHiddenInputFunction() {
        }

        @Override
        public Map<String, String> apply(HttpServletRequest request) {
            CsrfToken token = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
            if (token == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(token.getParameterName(), token.getToken());
        }
    }
}

