/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.saml2.provider.service.servlet.filter.Saml2WebSsoAuthenticationRequestFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class Saml2LoginConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractAuthenticationFilterConfigurer<B, Saml2LoginConfigurer<B>, Saml2WebSsoAuthenticationFilter> {
    private String loginPage;
    private String loginProcessingUrl = "/login/saml2/sso/{registrationId}";
    private AuthenticationRequestEndpointConfig authenticationRequestEndpoint = new AuthenticationRequestEndpointConfig();
    private RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;

    public Saml2LoginConfigurer relyingPartyRegistrationRepository(RelyingPartyRegistrationRepository repo) {
        this.relyingPartyRegistrationRepository = repo;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginPage(String loginPage) {
        Assert.hasText(loginPage, "loginPage cannot be empty");
        this.loginPage = loginPage;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText(loginProcessingUrl, "loginProcessingUrl cannot be empty");
        Assert.state(loginProcessingUrl.contains("{registrationId}"), "{registrationId} path variable is required");
        this.loginProcessingUrl = loginProcessingUrl;
        return this;
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl);
    }

    @Override
    public void init(B http) throws Exception {
        this.registerDefaultCsrfOverride(http);
        if (this.relyingPartyRegistrationRepository == null) {
            this.relyingPartyRegistrationRepository = this.getSharedOrBean(http, RelyingPartyRegistrationRepository.class);
        }
        Saml2WebSsoAuthenticationFilter webSsoFilter = new Saml2WebSsoAuthenticationFilter(this.relyingPartyRegistrationRepository, this.loginProcessingUrl);
        this.setAuthenticationFilter(webSsoFilter);
        super.loginProcessingUrl(this.loginProcessingUrl);
        if (StringUtils.hasText(this.loginPage)) {
            super.loginPage(this.loginPage);
            super.init(http);
        } else {
            boolean singleProvider;
            Map<String, String> providerUrlMap = this.getIdentityProviderUrlMap(this.authenticationRequestEndpoint.filterProcessingUrl, this.relyingPartyRegistrationRepository);
            boolean bl = singleProvider = providerUrlMap.size() == 1;
            if (singleProvider) {
                this.updateAuthenticationDefaults();
                this.updateAccessDefaults(http);
                String loginUrl = providerUrlMap.entrySet().iterator().next().getKey();
                LoginUrlAuthenticationEntryPoint entryPoint = new LoginUrlAuthenticationEntryPoint(loginUrl);
                this.registerAuthenticationEntryPoint(http, entryPoint);
            } else {
                super.init(http);
            }
        }
        http.authenticationProvider(this.getAuthenticationProvider());
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(B http) throws Exception {
        http.addFilter(this.authenticationRequestEndpoint.build(http));
        super.configure(http);
    }

    private AuthenticationProvider getAuthenticationProvider() {
        OpenSamlAuthenticationProvider provider = new OpenSamlAuthenticationProvider();
        return (AuthenticationProvider)this.postProcess(provider);
    }

    private void registerDefaultCsrfOverride(B http) {
        CsrfConfigurer csrf = http.getConfigurer(CsrfConfigurer.class);
        if (csrf == null) {
            return;
        }
        csrf.ignoringRequestMatchers(new AntPathRequestMatcher(this.loginProcessingUrl));
    }

    private void initDefaultLoginFilter(B http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null || this.isCustomLoginPage()) {
            return;
        }
        loginPageGeneratingFilter.setSaml2LoginEnabled(true);
        loginPageGeneratingFilter.setSaml2AuthenticationUrlToProviderName(this.getIdentityProviderUrlMap(this.authenticationRequestEndpoint.filterProcessingUrl, this.relyingPartyRegistrationRepository));
        loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
        loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
    }

    private Map<String, String> getIdentityProviderUrlMap(String authRequestPrefixUrl, RelyingPartyRegistrationRepository idpRepo) {
        LinkedHashMap<String, String> idps = new LinkedHashMap<String, String>();
        if (idpRepo instanceof Iterable) {
            Iterable repo = (Iterable)idpRepo;
            repo.forEach(p -> idps.put(authRequestPrefixUrl.replace("{registrationId}", p.getRegistrationId()), p.getRegistrationId()));
        }
        return idps;
    }

    private <C> C getSharedOrBean(B http, Class<C> clazz) {
        C shared = http.getSharedObject(clazz);
        if (shared != null) {
            return shared;
        }
        return this.getBeanOrNull(http, clazz);
    }

    private <C> C getBeanOrNull(B http, Class<C> clazz) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        try {
            return context.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            return null;
        }
    }

    private <C> void setSharedObject(B http, Class<C> clazz, C object) {
        if (http.getSharedObject(clazz) == null) {
            http.setSharedObject(clazz, object);
        }
    }

    private final class AuthenticationRequestEndpointConfig {
        private String filterProcessingUrl = "/saml2/authenticate/{registrationId}";

        private AuthenticationRequestEndpointConfig() {
        }

        private Filter build(B http) {
            Saml2AuthenticationRequestFactory authenticationRequestResolver = this.getResolver(http);
            Saml2WebSsoAuthenticationRequestFilter authenticationRequestFilter = new Saml2WebSsoAuthenticationRequestFilter(Saml2LoginConfigurer.this.relyingPartyRegistrationRepository);
            authenticationRequestFilter.setAuthenticationRequestFactory(authenticationRequestResolver);
            return authenticationRequestFilter;
        }

        private Saml2AuthenticationRequestFactory getResolver(B http) {
            Saml2AuthenticationRequestFactory resolver = (Saml2AuthenticationRequestFactory)Saml2LoginConfigurer.this.getSharedOrBean(http, Saml2AuthenticationRequestFactory.class);
            if (resolver == null) {
                resolver = new OpenSamlAuthenticationRequestFactory();
            }
            return resolver;
        }
    }
}

