/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractConfigAttributeRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.util.matcher.RequestMatcher;

final class PermitAllSupport {
    public static void permitAll(HttpSecurityBuilder<? extends HttpSecurityBuilder<?>> http, String ... urls) {
        for (String url : urls) {
            if (url == null) continue;
            PermitAllSupport.permitAll(http, new ExactUrlRequestMatcher(url));
        }
    }

    public static void permitAll(HttpSecurityBuilder<? extends HttpSecurityBuilder<?>> http, RequestMatcher ... requestMatchers) {
        ExpressionUrlAuthorizationConfigurer configurer = http.getConfigurer(ExpressionUrlAuthorizationConfigurer.class);
        if (configurer == null) {
            throw new IllegalStateException("permitAll only works with HttpSecurity.authorizeRequests()");
        }
        for (RequestMatcher matcher : requestMatchers) {
            if (matcher == null) continue;
            configurer.getRegistry().addMapping(0, new AbstractConfigAttributeRequestMatcherRegistry.UrlMapping(matcher, SecurityConfig.createList("permitAll")));
        }
    }

    private PermitAllSupport() {
    }

    private static final class ExactUrlRequestMatcher
    implements RequestMatcher {
        private String processUrl;

        private ExactUrlRequestMatcher(String processUrl) {
            this.processUrl = processUrl;
        }

        @Override
        public boolean matches(HttpServletRequest request) {
            String uri = request.getRequestURI();
            String query2 = request.getQueryString();
            if (query2 != null) {
                uri = uri + "?" + query2;
            }
            if ("".equals(request.getContextPath())) {
                return uri.equals(this.processUrl);
            }
            return uri.equals(request.getContextPath() + this.processUrl);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ExactUrl [processUrl='").append(this.processUrl).append("']");
            return sb.toString();
        }
    }
}

