/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcBeanDefinitionReader {
    private final PropertiesBeanDefinitionReader propReader;
    @Nullable
    private JdbcTemplate jdbcTemplate;

    public JdbcBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        this.propReader = new PropertiesBeanDefinitionReader(beanFactory);
    }

    public JdbcBeanDefinitionReader(PropertiesBeanDefinitionReader beanDefinitionReader) {
        Assert.notNull((Object)beanDefinitionReader, "Bean definition reader must not be null");
        this.propReader = beanDefinitionReader;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, "JdbcTemplate must not be null");
        this.jdbcTemplate = jdbcTemplate;
    }

    public void loadBeanDefinitions(String sql) {
        Assert.notNull((Object)this.jdbcTemplate, "Not fully configured - specify DataSource or JdbcTemplate");
        Properties props = new Properties();
        this.jdbcTemplate.query(sql, rs -> {
            String beanName = rs.getString(1);
            String property = rs.getString(2);
            String value = rs.getString(3);
            props.setProperty(beanName + '.' + property, value);
        });
        this.propReader.registerBeanDefinitions(props);
    }
}

