/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.metadata.CallParameterMetaData;
import org.springframework.jdbc.core.metadata.GenericCallMetaDataProvider;
import org.springframework.lang.Nullable;

public class OracleCallMetaDataProvider
extends GenericCallMetaDataProvider {
    private static final String REF_CURSOR_NAME = "REF CURSOR";

    public OracleCallMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        super(databaseMetaData);
    }

    @Override
    public boolean isReturnResultSetSupported() {
        return false;
    }

    @Override
    public boolean isRefCursorSupported() {
        return true;
    }

    @Override
    public int getRefCursorSqlType() {
        return -10;
    }

    @Override
    @Nullable
    public String metaDataCatalogNameToUse(@Nullable String catalogName) {
        return catalogName == null ? "" : this.catalogNameToUse(catalogName);
    }

    @Override
    @Nullable
    public String metaDataSchemaNameToUse(@Nullable String schemaName) {
        return schemaName == null ? this.getUserName() : super.metaDataSchemaNameToUse(schemaName);
    }

    @Override
    public SqlParameter createDefaultOutParameter(String parameterName, CallParameterMetaData meta) {
        if (meta.getSqlType() == 1111 && REF_CURSOR_NAME.equals(meta.getTypeName())) {
            return new SqlOutParameter(parameterName, this.getRefCursorSqlType(), new ColumnMapRowMapper());
        }
        return super.createDefaultOutParameter(parameterName, meta);
    }
}

