/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.uis.V2;

import com.contrastsecurity.cassandra.migration.api.JavaMigration;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.eaio.uuid.UUID;
import eu.europeana.cloud.common.utils.Bucket;
import eu.europeana.cloud.service.commons.utils.BucketsHandler;
import java.util.Iterator;
import migrations.common.TableCopier;

public class V2_5__DataFromTemporaryTable___Copier___provider_record_id
implements JavaMigration {
    private static final String SOURCE_TABLE = "provider_record_id_copy";
    private static final String TARGET_TABLE = "provider_record_id";
    private static final String PROVIDER_RECORD_ID_BUCKETS_TABLE = "provider_record_id_buckets";
    PreparedStatement selectFromTemporaryStatement;
    PreparedStatement insertToProviderRecordIdStatement;

    private void initStatements(Session session) {
        String selectFromTemporary = "SELECT  provider_id, record_id, cloud_id  FROM provider_record_id_copy ;\n";
        String insertToProviderRecordId = "INSERT INTO provider_record_id (provider_id,bucket_id, record_id, cloud_id) VALUES (?,?,?,?);\n";
        this.selectFromTemporaryStatement = session.prepare("SELECT  provider_id, record_id, cloud_id  FROM provider_record_id_copy ;\n");
        this.selectFromTemporaryStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.insertToProviderRecordIdStatement = session.prepare("INSERT INTO provider_record_id (provider_id,bucket_id, record_id, cloud_id) VALUES (?,?,?,?);\n");
        this.insertToProviderRecordIdStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
    }

    @Override
    public void migrate(Session session) {
        long counter = 0L;
        BucketsHandler bucketsHandler = new BucketsHandler(session);
        this.initStatements(session);
        BoundStatement boundStatement = this.selectFromTemporaryStatement.bind();
        boundStatement.setFetchSize(100);
        ResultSet rs = session.execute(boundStatement);
        Iterator<Row> ri = rs.iterator();
        while (TableCopier.hasNextRow(ri)) {
            Row providerRecordIdRow = ri.next();
            Bucket bucket = bucketsHandler.getCurrentBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, providerRecordIdRow.getString("provider_id"));
            if (bucket == null || bucket.getRowsCount() >= 950000L) {
                bucket = new Bucket(providerRecordIdRow.getString("provider_id"), new UUID().toString(), 0L);
            }
            bucketsHandler.increaseBucketCount(PROVIDER_RECORD_ID_BUCKETS_TABLE, bucket);
            this.insertToProviderRecordIdTable(session, bucket.getBucketId(), providerRecordIdRow);
            if (++counter % 10000L != 0L) continue;
            System.out.print("\rCopy table progress: " + counter);
        }
        if (counter > 0L) {
            System.out.println("\rCopy table progress: " + counter);
        }
    }

    private void insertToProviderRecordIdTable(Session session, String bucketId, Row providerRecordIdRow) {
        BoundStatement boundStatement = this.insertToProviderRecordIdStatement.bind(providerRecordIdRow.getString("provider_id"), java.util.UUID.fromString(bucketId), providerRecordIdRow.getString("record_id"), providerRecordIdRow.getString("cloud_id"));
        session.execute(boundStatement);
    }
}

