/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.mcs.V15;

import com.contrastsecurity.cassandra.migration.api.JavaMigration;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import migrations.common.TableCopier;
import migrations.service.mcs.V15.PartitionMigrator;

public class V15_1__copy_data
implements JavaMigration {
    private static final Log LOG = LogFactory.getLog(V15_1__copy_data.class);
    private PreparedStatement distinctPartitionValues;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);

    private void initStatements(Session session) {
        this.distinctPartitionValues = session.prepare("select DISTINCT provider_id, dataset_id from data_set_assignments_by_revision_id_replica;");
    }

    @Override
    public void migrate(Session session) throws Exception {
        this.initStatements(session);
        BoundStatement partitionValuesStatement = this.distinctPartitionValues.bind();
        partitionValuesStatement.setFetchSize(1000);
        ResultSet resultSet = session.execute(partitionValuesStatement);
        Iterator<Row> iterator = resultSet.iterator();
        while (TableCopier.hasNextRow(iterator)) {
            Row row = iterator.next();
            LOG.info("Submitting task for: " + row.getString("provider_id") + ":" + row.getString("dataset_id"));
            this.executorService.submit(new PartitionMigrator(session, row.getString("provider_id"), row.getString("dataset_id")));
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(100L, TimeUnit.DAYS);
    }
}

