/*
 * Decompiled with CFR 0.152.
 */
package migrations.service.mcs.V13;

import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.eaio.uuid.UUID;
import eu.europeana.cloud.common.utils.Bucket;
import eu.europeana.cloud.service.commons.utils.BucketsHandler;
import java.util.Iterator;
import migrations.common.TableCopier;

class PartitionMigrator
implements Runnable {
    private static final Log LOG = LogFactory.getLog(PartitionMigrator.class);
    protected static final String CDSID_SEPARATOR = "\n";
    private static final int MAX_DATASET_ASSIGNMENTS_BY_REVISION_ID_BUCKET_COUNT = 250000;
    private Session session;
    private String provider_id;
    private String dataset_id;
    private PreparedStatement selectStatement;
    private PreparedStatement insertStatement;

    private void initStatements(Session session) {
        this.selectStatement = session.prepare("SELECT * FROM data_set_assignments_by_revision_id where provider_id = ? and dataset_id = ?");
        this.insertStatement = session.prepare("INSERT INTO data_set_assignments_by_revision_id_v1 (provider_id,dataset_id,bucket_id,revision_provider_id,revision_name,revision_timestamp,representation_id,cloud_id,published,acceptance, mark_deleted) VALUES (?,?,?,?,?,?,?,?,?,?,?);");
        this.selectStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
        this.insertStatement.setConsistencyLevel(ConsistencyLevel.QUORUM);
    }

    public PartitionMigrator(Session session, String provider_id, String dataset_id) {
        this.session = session;
        this.provider_id = provider_id;
        this.dataset_id = dataset_id;
    }

    @Override
    public void run() {
        try {
            LOG.info("Starting migration for for: " + this.provider_id + ":" + this.dataset_id);
            BucketsHandler bucketsHandler = new BucketsHandler(this.session);
            this.initStatements(this.session);
            long counter = 0L;
            BoundStatement boundStatement = this.selectStatement.bind(this.provider_id, this.dataset_id);
            boundStatement.setFetchSize(1000);
            ResultSet rs = this.session.execute(boundStatement);
            Iterator<Row> ri = rs.iterator();
            while (TableCopier.hasNextRow(ri)) {
                Row dataset_assignment = ri.next();
                Bucket bucket = bucketsHandler.getCurrentBucket("data_set_assignments_by_revision_id_buckets", this.createProviderDataSetId(dataset_assignment.getString("provider_id"), dataset_assignment.getString("dataset_id")));
                if (bucket == null || bucket.getRowsCount() >= 250000L) {
                    bucket = new Bucket(this.createProviderDataSetId(dataset_assignment.getString("provider_id"), dataset_assignment.getString("dataset_id")), new UUID().toString(), 0L);
                }
                bucketsHandler.increaseBucketCount("data_set_assignments_by_revision_id_buckets", bucket);
                this.insertRowToAssignmentsByRepresentationsTable(this.session, dataset_assignment, bucket.getBucketId());
                if (++counter % 10000L != 0L) continue;
                LOG.info("Copy table progress: " + counter);
            }
            LOG.info("Migration finished successfully for: " + this.provider_id + ":" + this.dataset_id + ". Migrated rows: " + counter);
        }
        catch (Exception e) {
            LOG.info("FAILED to execute migration for: " + this.provider_id + ":" + this.dataset_id);
        }
    }

    private void insertRowToAssignmentsByRepresentationsTable(Session session, Row sourceRow, String bucketId) {
        BoundStatement boundStatement = this.insertStatement.bind(sourceRow.getString("provider_id"), sourceRow.getString("dataset_id"), java.util.UUID.fromString(bucketId), sourceRow.getString("revision_provider_id"), sourceRow.getString("revision_name"), sourceRow.getDate("revision_timestamp"), sourceRow.getString("representation_id"), sourceRow.getString("cloud_id"), sourceRow.getBool("published"), sourceRow.getBool("acceptance"), sourceRow.getBool("mark_deleted"));
        session.execute(boundStatement);
    }

    private String createProviderDataSetId(String providerId, String dataSetId) {
        return providerId + CDSID_SEPARATOR + dataSetId;
    }
}

