/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.logging;

import eu.europeana.cloud.service.commons.logging.LoggingMessage;

public class LoggingMessageBuilder {
    private int statusCode;
    private long requestTime;
    private String remoteAddr;
    private String resourcePath;
    private String requestMethod;
    private static String LOG_MESSAGE_PATTERN = "%STATUS_CODE %REQUEST_TIME %CLIENT_IP %REQUEST_METHOD %RESOURCE_PATH Request received";

    public LoggingMessage build() {
        String message = LOG_MESSAGE_PATTERN;
        message = message.replace("%STATUS_CODE", "" + this.statusCode);
        message = message.replace("%REQUEST_TIME", this.requestTime + "ms");
        message = message.replace("%CLIENT_IP", this.remoteAddr);
        message = message.replace("%RESOURCE_PATH", this.resourcePath);
        message = message.replace("%REQUEST_METHOD", this.requestMethod);
        LoggingMessage m3 = new LoggingMessage();
        m3.setMessage(message);
        m3.setStatus(this.statusCode);
        return m3;
    }

    public LoggingMessageBuilder withStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public LoggingMessageBuilder withRequestTime(long requestTime) {
        this.requestTime = requestTime;
        return this;
    }

    public LoggingMessageBuilder withRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    public LoggingMessageBuilder withResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public LoggingMessageBuilder withRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }
}

