/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import com.eaio.util.Resource;
import com.eaio.util.lang.Hex;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;

public final class UUIDGen {
    private static AtomicLong lastTime = new AtomicLong(Long.MIN_VALUE);
    private static String macAddress = null;
    private static long clockSeqAndNode = Long.MIN_VALUE;

    private static void initializeClockSeqAndNodeFromIPAddress() {
        try {
            byte[] local = InetAddress.getLocalHost().getAddress();
            clockSeqAndNode |= (long)(local[0] << 24) & 0xFF000000L;
            clockSeqAndNode |= (long)(local[1] << 16 & 0xFF0000);
            clockSeqAndNode |= (long)(local[2] << 8 & 0xFF00);
            clockSeqAndNode |= (long)(local[3] & 0xFF);
        }
        catch (UnknownHostException ex) {
            clockSeqAndNode |= (long)(Math.random() * 2.147483647E9);
        }
    }

    private static boolean inDockerContainer() {
        boolean out = false;
        try {
            File f = new File("/.dockerenv");
            out = f.exists() && !f.isDirectory();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return out;
    }

    private static String getFirstMACAddressFromNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            if (ifs != null) {
                while (ifs.hasMoreElements()) {
                    NetworkInterface iface = ifs.nextElement();
                    byte[] hardware = iface.getHardwareAddress();
                    if (hardware == null || hardware.length != 6 || hardware[1] == -1) continue;
                    return Hex.append((Appendable)new StringBuilder(36), hardware).toString();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static long getClockSeqAndNode() {
        return clockSeqAndNode;
    }

    public static long newTime() {
        return UUIDGen.createTime(System.currentTimeMillis());
    }

    public static long createTime(long currentTimeMillis) {
        long timeMillis;
        block2: {
            long current;
            timeMillis = currentTimeMillis * 10000L + 122192928000000000L;
            while (true) {
                if (timeMillis > (current = lastTime.get())) {
                    if (!lastTime.compareAndSet(current, timeMillis)) continue;
                    break block2;
                }
                if (lastTime.compareAndSet(current, current + 1L)) break;
            }
            timeMillis = current + 1L;
        }
        long time = timeMillis << 32;
        time |= (timeMillis & 0xFFFF00000000L) >> 16;
        return time |= 0x1000L | timeMillis >> 48 & 0xFFFL;
    }

    public static String getMACAddress() {
        return macAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFirstLineOfCommand(String ... commands) throws IOException {
        String string;
        block3: {
            Process p = null;
            BufferedReader reader = null;
            try {
                p = Runtime.getRuntime().exec(commands);
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()), 128);
                string = reader.readLine();
                if (p == null) break block3;
            }
            catch (Throwable throwable) {
                if (p != null) {
                    Resource.close(reader, p.getErrorStream(), p.getOutputStream());
                    p.destroy();
                }
                throw throwable;
            }
            Resource.close(reader, p.getErrorStream(), p.getOutputStream());
            p.destroy();
        }
        return string;
    }

    static {
        if (UUIDGen.inDockerContainer()) {
            try {
                macAddress = UUIDGen.getFirstLineOfCommand("hostname");
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (macAddress == null) {
            macAddress = UUIDGen.getFirstMACAddressFromNetworkInterfaces();
        }
        if (macAddress == null) {
            UUIDGen.initializeClockSeqAndNodeFromIPAddress();
        } else {
            clockSeqAndNode |= Hex.parseLong(macAddress);
        }
        clockSeqAndNode |= (long)(Math.random() * 16383.0) << 48;
    }
}

