/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.utils;

public class FeatureDetector {
    private ClassLoader classLoader;
    private Boolean slf4jAvailable;
    private Boolean apacheCommonsLoggingAvailable;

    public FeatureDetector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isApacheCommonsLoggingAvailable() {
        if (this.apacheCommonsLoggingAvailable == null) {
            this.apacheCommonsLoggingAvailable = this.isPresent("org.apache.commons.logging.Log", this.classLoader);
        }
        return this.apacheCommonsLoggingAvailable;
    }

    public boolean isSlf4jAvailable() {
        if (this.slf4jAvailable == null) {
            this.slf4jAvailable = this.isPresent("org.slf4j.Logger", this.classLoader);
        }
        return this.slf4jAvailable;
    }

    private boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

