/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.script;

import com.contrastsecurity.cassandra.migration.script.Delimiter;
import com.contrastsecurity.cassandra.migration.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class CqlStatementBuilder {
    private StringBuilder statement = new StringBuilder();
    private int lineNumber;
    private boolean empty = true;
    private boolean terminated;
    private boolean insideQuoteStringLiteral = false;
    private boolean insideAlternateQuoteStringLiteral = false;
    private String alternateQuote;
    private boolean lineEndsWithSingleLineComment = false;
    private boolean insideMultiLineComment = false;
    private boolean nonCommentStatementPartSeen = false;
    private Delimiter delimiter = this.getDefaultDelimiter();

    protected Delimiter getDefaultDelimiter() {
        return new Delimiter(";", false);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public String getCqlStatement() {
        return this.statement.toString();
    }

    public Delimiter extractNewDelimiterFromLine(String line) {
        return null;
    }

    public boolean isCommentDirective(String line) {
        return false;
    }

    protected boolean isSingleLineComment(String line) {
        return line.startsWith("--");
    }

    public void addLine(String line) {
        if (this.isEmpty()) {
            this.empty = false;
        } else {
            this.statement.append("\n");
        }
        String lineSimplified = this.simplifyLine(line);
        this.applyStateChanges(lineSimplified);
        if (this.endWithOpenMultilineStringLiteral() || this.insideMultiLineComment) {
            this.statement.append(line);
            return;
        }
        this.delimiter = this.changeDelimiterIfNecessary(lineSimplified, this.delimiter);
        this.statement.append(line);
        if (this.isCommentDirective(lineSimplified)) {
            this.nonCommentStatementPartSeen = true;
        }
        if (!this.lineEndsWithSingleLineComment && this.lineTerminatesStatement(lineSimplified, this.delimiter)) {
            CqlStatementBuilder.stripDelimiter(this.statement, this.delimiter);
            this.terminated = true;
        }
    }

    boolean endWithOpenMultilineStringLiteral() {
        return this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral;
    }

    public boolean canDiscard() {
        return !this.insideAlternateQuoteStringLiteral && !this.insideQuoteStringLiteral && !this.insideMultiLineComment && !this.nonCommentStatementPartSeen;
    }

    protected String simplifyLine(String line) {
        return this.removeEscapedQuotes(line).replace("--", " -- ").replaceAll("\\s+", " ").trim().toUpperCase();
    }

    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        return delimiter;
    }

    private boolean lineTerminatesStatement(String line, Delimiter delimiter) {
        if (delimiter == null) {
            return false;
        }
        String upperCaseDelimiter = delimiter.getDelimiter().toUpperCase();
        if (delimiter.isAloneOnLine()) {
            return line.equals(upperCaseDelimiter);
        }
        return line.endsWith(upperCaseDelimiter);
    }

    static void stripDelimiter(StringBuilder cql, Delimiter delimiter) {
        int last;
        for (last = cql.length(); last > 0 && Character.isWhitespace(cql.charAt(last - 1)); --last) {
        }
        cql.delete(last - delimiter.getDelimiter().length(), cql.length());
    }

    protected String extractAlternateOpenQuote(String token) {
        return null;
    }

    protected String computeAlternateCloseQuote(String openQuote) {
        return openQuote;
    }

    protected void applyStateChanges(String line) {
        String[] tokens = StringUtils.tokenizeToStringArray(line, " @<>;:=|(),+{}");
        List<TokenType> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        this.lineEndsWithSingleLineComment = false;
        for (TokenType delimitingToken : delimitingTokens) {
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && TokenType.MULTI_LINE_COMMENT.equals((Object)delimitingToken)) {
                boolean bl = this.insideMultiLineComment = !this.insideMultiLineComment;
            }
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && !this.insideMultiLineComment && TokenType.SINGLE_LINE_COMMENT.equals((Object)delimitingToken)) {
                this.lineEndsWithSingleLineComment = true;
                return;
            }
            if (!this.insideMultiLineComment && !this.insideQuoteStringLiteral && TokenType.ALTERNATE_QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideAlternateQuoteStringLiteral = !this.insideAlternateQuoteStringLiteral;
            }
            if (!this.insideMultiLineComment && !this.insideAlternateQuoteStringLiteral && TokenType.QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideQuoteStringLiteral = !this.insideQuoteStringLiteral;
            }
            if (this.insideMultiLineComment || this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral || !TokenType.OTHER.equals((Object)delimitingToken)) continue;
            this.nonCommentStatementPartSeen = true;
        }
    }

    private List<TokenType> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<TokenType> delimitingTokens = new ArrayList<TokenType>();
        for (String token : tokens) {
            String alternateQuoteFromToken;
            String cleanToken = this.cleanToken(token);
            boolean handled = false;
            if (this.alternateQuote == null && (alternateQuoteFromToken = this.extractAlternateOpenQuote(cleanToken)) != null) {
                String closeQuote = this.computeAlternateCloseQuote(alternateQuoteFromToken);
                if (cleanToken.length() >= alternateQuoteFromToken.length() + closeQuote.length() && cleanToken.startsWith(alternateQuoteFromToken) && cleanToken.endsWith(closeQuote)) continue;
                this.alternateQuote = closeQuote;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (this.alternateQuote != null && cleanToken.endsWith(this.alternateQuote)) {
                this.alternateQuote = null;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (cleanToken.length() >= 2 && cleanToken.startsWith("'") && cleanToken.endsWith("'") || cleanToken.length() >= 4 && cleanToken.startsWith("/*") && cleanToken.endsWith("*/")) continue;
            if (this.isSingleLineComment(cleanToken)) {
                delimitingTokens.add(TokenType.SINGLE_LINE_COMMENT);
                handled = true;
            }
            if (cleanToken.startsWith("/*")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT);
                handled = true;
            } else if (cleanToken.startsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (!cleanToken.startsWith("/*") && cleanToken.endsWith("*/")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT);
                handled = true;
            } else if (!cleanToken.startsWith("'") && cleanToken.endsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (handled) continue;
            delimitingTokens.add(TokenType.OTHER);
        }
        return delimitingTokens;
    }

    protected String removeEscapedQuotes(String token) {
        return StringUtils.replaceAll(token, "''", "");
    }

    protected String cleanToken(String token) {
        return token;
    }

    private static enum TokenType {
        OTHER,
        QUOTE,
        ALTERNATE_QUOTE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT;

    }
}

