/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.resolver.cql;

import com.contrastsecurity.cassandra.migration.config.MigrationType;
import com.contrastsecurity.cassandra.migration.config.ScriptsLocation;
import com.contrastsecurity.cassandra.migration.info.MigrationVersion;
import com.contrastsecurity.cassandra.migration.info.ResolvedMigration;
import com.contrastsecurity.cassandra.migration.resolver.MigrationInfoHelper;
import com.contrastsecurity.cassandra.migration.resolver.MigrationResolver;
import com.contrastsecurity.cassandra.migration.resolver.ResolvedMigrationComparator;
import com.contrastsecurity.cassandra.migration.resolver.cql.CqlMigrationExecutor;
import com.contrastsecurity.cassandra.migration.utils.Pair;
import com.contrastsecurity.cassandra.migration.utils.scanner.Resource;
import com.contrastsecurity.cassandra.migration.utils.scanner.Scanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;

public class CqlMigrationResolver
implements MigrationResolver {
    private final Scanner scanner;
    private final ScriptsLocation location;
    private final String encoding;
    private static final String CQL_MIGRATION_PREFIX = "V";
    private static final String CQL_MIGRATION_SEPARATOR = "__";
    private static final String CQL_MIGRATION_SUFFIX = ".cql";

    public CqlMigrationResolver(ClassLoader classLoader, ScriptsLocation location, String encoding) {
        this.scanner = new Scanner(classLoader);
        this.location = location;
        this.encoding = encoding;
    }

    public List<ResolvedMigration> resolveMigrations() {
        Resource[] resources;
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        for (Resource resource : resources = this.scanner.scanForResources(this.location, CQL_MIGRATION_PREFIX, CQL_MIGRATION_SUFFIX)) {
            ResolvedMigration resolvedMigration = this.extractMigrationInfo(resource);
            resolvedMigration.setPhysicalLocation(resource.getLocationOnDisk());
            resolvedMigration.setExecutor(new CqlMigrationExecutor(resource, this.encoding));
            migrations.add(resolvedMigration);
        }
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    private ResolvedMigration extractMigrationInfo(Resource resource) {
        ResolvedMigration migration = new ResolvedMigration();
        Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(resource.getFilename(), CQL_MIGRATION_PREFIX, CQL_MIGRATION_SEPARATOR, CQL_MIGRATION_SUFFIX);
        migration.setVersion(info.getLeft());
        migration.setDescription(info.getRight());
        migration.setScript(this.extractScriptName(resource));
        migration.setChecksum(CqlMigrationResolver.calculateChecksum(resource.loadAsBytes()));
        migration.setType(MigrationType.CQL);
        return migration;
    }

    String extractScriptName(Resource resource) {
        if (this.location.getPath().isEmpty()) {
            return resource.getLocation();
        }
        return resource.getLocation().substring(this.location.getPath().length() + 1);
    }

    private static int calculateChecksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return (int)crc32.getValue();
    }
}

