/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.logging.console;

import com.contrastsecurity.cassandra.migration.logging.Log;

public class ConsoleLog
implements Log {
    private final Level level;

    public ConsoleLog(Level level) {
        this.level = level;
    }

    @Override
    public void debug(String message) {
        if (this.level == Level.DEBUG) {
            System.out.println("DEBUG: " + message);
        }
    }

    @Override
    public void info(String message) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            System.out.println(message);
        }
    }

    @Override
    public void warn(String message) {
        System.out.println("WARNING: " + message);
    }

    @Override
    public void error(String message) {
        System.out.println("ERROR: " + message);
    }

    @Override
    public void error(String message, Exception e) {
        System.out.println("ERROR: " + message);
        e.printStackTrace();
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN;

    }
}

