/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.info;

import com.contrastsecurity.cassandra.migration.config.MigrationType;
import com.contrastsecurity.cassandra.migration.dao.SchemaVersionDAO;
import com.contrastsecurity.cassandra.migration.info.AppliedMigration;
import com.contrastsecurity.cassandra.migration.info.MigrationInfo;
import com.contrastsecurity.cassandra.migration.info.MigrationInfoContext;
import com.contrastsecurity.cassandra.migration.info.MigrationState;
import com.contrastsecurity.cassandra.migration.info.MigrationVersion;
import com.contrastsecurity.cassandra.migration.info.ResolvedMigration;
import com.contrastsecurity.cassandra.migration.resolver.MigrationResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class MigrationInfoService {
    private final MigrationResolver migrationResolver;
    private final SchemaVersionDAO schemaVersionDAO;
    private MigrationVersion target;
    private boolean outOfOrder;
    private final boolean pendingOrFuture;
    private List<MigrationInfo> migrationInfos;

    public MigrationInfoService(MigrationResolver migrationResolver, SchemaVersionDAO schemaVersionDAO, MigrationVersion target, boolean outOfOrder, boolean pendingOrFuture) {
        this.migrationResolver = migrationResolver;
        this.schemaVersionDAO = schemaVersionDAO;
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.pendingOrFuture = pendingOrFuture;
    }

    public void refresh() {
        Collection<ResolvedMigration> availableMigrations = this.migrationResolver.resolveMigrations();
        List<AppliedMigration> appliedMigrations = this.schemaVersionDAO.findAppliedMigrations();
        this.migrationInfos = this.mergeAvailableAndAppliedMigrations(availableMigrations, appliedMigrations);
        if (MigrationVersion.CURRENT == this.target) {
            this.target = this.current().getVersion();
        }
    }

    List<MigrationInfo> mergeAvailableAndAppliedMigrations(Collection<ResolvedMigration> resolvedMigrations, List<AppliedMigration> appliedMigrations) {
        MigrationInfoContext context = new MigrationInfoContext();
        context.outOfOrder = this.outOfOrder;
        context.pendingOrFuture = this.pendingOrFuture;
        context.target = this.target;
        TreeMap<MigrationVersion, ResolvedMigration> resolvedMigrationsMap = new TreeMap<MigrationVersion, ResolvedMigration>();
        for (ResolvedMigration resolvedMigration : resolvedMigrations) {
            MigrationVersion version = resolvedMigration.getVersion();
            if (version.compareTo(context.lastResolved) > 0) {
                context.lastResolved = version;
            }
            resolvedMigrationsMap.put(version, resolvedMigration);
        }
        TreeMap<MigrationVersion, AppliedMigration> appliedMigrationsMap = new TreeMap<MigrationVersion, AppliedMigration>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            MigrationVersion version = appliedMigration.getVersion();
            if (version.compareTo(context.lastApplied) > 0) {
                context.lastApplied = version;
            }
            if (appliedMigration.getType() == MigrationType.SCHEMA) {
                context.schema = version;
            }
            if (appliedMigration.getType() == MigrationType.BASELINE) {
                context.baseline = version;
            }
            appliedMigrationsMap.put(version, appliedMigration);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(resolvedMigrationsMap.keySet());
        hashSet.addAll(appliedMigrationsMap.keySet());
        ArrayList<MigrationInfo> migrationInfos = new ArrayList<MigrationInfo>();
        for (MigrationVersion version : hashSet) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedMigrationsMap.get(version);
            AppliedMigration appliedMigration = (AppliedMigration)appliedMigrationsMap.get(version);
            migrationInfos.add(new MigrationInfo(resolvedMigration, appliedMigration, context));
        }
        Collections.sort(migrationInfos);
        return migrationInfos;
    }

    public MigrationInfo[] all() {
        return this.migrationInfos.toArray(new MigrationInfo[this.migrationInfos.size()]);
    }

    public MigrationInfo current() {
        for (int i = this.migrationInfos.size() - 1; i >= 0; --i) {
            MigrationInfo migrationInfo = this.migrationInfos.get(i);
            if (!migrationInfo.getState().isApplied()) continue;
            return migrationInfo;
        }
        return null;
    }

    public MigrationInfo[] pending() {
        ArrayList<MigrationInfo> pendingMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (MigrationState.PENDING != migrationInfo.getState()) continue;
            pendingMigrations.add(migrationInfo);
        }
        return pendingMigrations.toArray(new MigrationInfo[pendingMigrations.size()]);
    }

    public MigrationInfo[] applied() {
        ArrayList<MigrationInfo> appliedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied()) continue;
            appliedMigrations.add(migrationInfo);
        }
        return appliedMigrations.toArray(new MigrationInfo[appliedMigrations.size()]);
    }

    public MigrationInfo[] resolved() {
        ArrayList<MigrationInfo> resolvedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isResolved()) continue;
            resolvedMigrations.add(migrationInfo);
        }
        return resolvedMigrations.toArray(new MigrationInfo[resolvedMigrations.size()]);
    }

    public MigrationInfo[] failed() {
        ArrayList<MigrationInfo> failedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isFailed()) continue;
            failedMigrations.add(migrationInfo);
        }
        return failedMigrations.toArray(new MigrationInfo[failedMigrations.size()]);
    }

    public MigrationInfo[] future() {
        ArrayList<MigrationInfo> futureMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.FUTURE_SUCCESS && migrationInfo.getState() != MigrationState.FUTURE_FAILED) continue;
            futureMigrations.add(migrationInfo);
        }
        return futureMigrations.toArray(new MigrationInfo[futureMigrations.size()]);
    }

    public MigrationInfo[] outOfOrder() {
        ArrayList<MigrationInfo> outOfOrderMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.OUT_OF_ORDER) continue;
            outOfOrderMigrations.add(migrationInfo);
        }
        return outOfOrderMigrations.toArray(new MigrationInfo[outOfOrderMigrations.size()]);
    }

    public String validate() {
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            String message = migrationInfo.validate();
            if (message == null) continue;
            return message;
        }
        return null;
    }
}

