/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.dao;

import com.contrastsecurity.cassandra.migration.config.Keyspace;
import com.contrastsecurity.cassandra.migration.config.MigrationType;
import com.contrastsecurity.cassandra.migration.info.AppliedMigration;
import com.contrastsecurity.cassandra.migration.info.MigrationVersion;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.contrastsecurity.cassandra.migration.utils.CachePrepareStatement;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SchemaVersionDAO {
    private static final Log LOG = LogFactory.getLog(SchemaVersionDAO.class);
    private static final String COUNTS_TABLE_NAME_SUFFIX = "_counts";
    private Session session;
    private Keyspace keyspace;
    private String tableName;
    private CachePrepareStatement cachePs;

    public SchemaVersionDAO(Session session, Keyspace keyspace, String tableName) {
        this.session = session;
        this.keyspace = keyspace;
        this.tableName = tableName;
        this.cachePs = new CachePrepareStatement(session);
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public void createTablesIfNotExist() {
        if (this.tablesExist()) {
            return;
        }
        SimpleStatement statement = new SimpleStatement("CREATE TABLE IF NOT EXISTS " + this.keyspace.getName() + "." + this.tableName + "(" + "  version_rank int," + "  installed_rank int," + "  version text," + "  description text," + "  script text," + "  checksum int," + "  type text," + "  installed_by text," + "  installed_on timestamp," + "  execution_time int," + "  success boolean," + "  PRIMARY KEY (version)" + ");");
        statement.setConsistencyLevel(ConsistencyLevel.ALL);
        this.session.execute(statement);
        statement = new SimpleStatement("CREATE TABLE IF NOT EXISTS " + this.keyspace.getName() + "." + this.tableName + COUNTS_TABLE_NAME_SUFFIX + " (" + "  name text," + "  count counter," + "  PRIMARY KEY (name)" + ");");
        statement.setConsistencyLevel(ConsistencyLevel.ALL);
        this.session.execute(statement);
    }

    public boolean tablesExist() {
        boolean schemaVersionTableExists = false;
        boolean schemaVersionCountsTableExists = false;
        Select.Where statement = QueryBuilder.select().column("columnfamily_name").from("System", "schema_columnfamilies").where(QueryBuilder.eq("keyspace_name", this.keyspace.getName())).and(QueryBuilder.in("columnfamily_name", this.tableName, this.tableName + COUNTS_TABLE_NAME_SUFFIX));
        ((Statement)statement).setConsistencyLevel(ConsistencyLevel.ALL);
        ResultSet results = this.session.execute(statement);
        for (Row row : results) {
            String table = row.getString("columnfamily_name");
            if (null != table && table.equalsIgnoreCase(this.tableName)) {
                schemaVersionTableExists = true;
            }
            if (null == table || !table.equalsIgnoreCase(this.tableName + COUNTS_TABLE_NAME_SUFFIX)) continue;
            schemaVersionCountsTableExists = true;
        }
        return schemaVersionTableExists && schemaVersionCountsTableExists;
    }

    public void addAppliedMigration(AppliedMigration appliedMigration) {
        this.createTablesIfNotExist();
        MigrationVersion version = appliedMigration.getVersion();
        int versionRank = this.calculateVersionRank(version);
        PreparedStatement statement = this.cachePs.prepare("INSERT INTO " + this.keyspace.getName() + "." + this.tableName + " (version_rank, installed_rank, version, description, type, script, checksum, installed_on," + "  installed_by, execution_time, success)" + " VALUES" + " (?, ?, ?, ?, ?, ?, ?, dateOf(now()), ?, ?, ?);");
        statement.setConsistencyLevel(ConsistencyLevel.ALL);
        this.session.execute(statement.bind(versionRank, this.calculateInstalledRank(), version.toString(), appliedMigration.getDescription(), appliedMigration.getType().name(), appliedMigration.getScript(), appliedMigration.getChecksum(), appliedMigration.getInstalledBy(), appliedMigration.getExecutionTime(), appliedMigration.isSuccess()));
        LOG.debug("Schema version table " + this.tableName + " successfully updated to reflect changes");
    }

    public List<AppliedMigration> findAppliedMigrations() {
        if (!this.tablesExist()) {
            return new ArrayList<AppliedMigration>();
        }
        Select select = QueryBuilder.select().column("version_rank").column("installed_rank").column("version").column("description").column("type").column("script").column("checksum").column("installed_on").column("installed_by").column("execution_time").column("success").from(this.keyspace.getName(), this.tableName);
        select.setConsistencyLevel(ConsistencyLevel.ALL);
        ResultSet results = this.session.execute(select);
        ArrayList<AppliedMigration> resultsList = new ArrayList<AppliedMigration>();
        for (Row row : results) {
            resultsList.add(new AppliedMigration(row.getInt("version_rank"), row.getInt("installed_rank"), MigrationVersion.fromVersion(row.getString("version")), row.getString("description"), MigrationType.valueOf(row.getString("type")), row.getString("script"), row.getInt("checksum"), row.getDate("installed_on"), row.getString("installed_by"), row.getInt("execution_time"), row.getBool("success")));
        }
        return resultsList;
    }

    private int calculateInstalledRank() {
        SimpleStatement statement = new SimpleStatement("UPDATE " + this.keyspace.getName() + "." + this.tableName + COUNTS_TABLE_NAME_SUFFIX + " SET count = count + 1" + "WHERE name = 'installed_rank';");
        this.session.execute(statement);
        Select select = QueryBuilder.select("count").from(this.tableName + COUNTS_TABLE_NAME_SUFFIX);
        select.where(QueryBuilder.eq("name", "installed_rank"));
        select.setConsistencyLevel(ConsistencyLevel.ALL);
        ResultSet result = this.session.execute(select);
        return (int)result.one().getLong("count");
    }

    private int calculateVersionRank(MigrationVersion version) {
        Select statement = QueryBuilder.select().column("version").column("version_rank").from(this.keyspace.getName(), this.tableName);
        statement.setConsistencyLevel(ConsistencyLevel.ALL);
        ResultSet versionRows = this.session.execute(statement);
        ArrayList<MigrationVersion> migrationVersions = new ArrayList<MigrationVersion>();
        HashMap<String, MigrationMetaHolder> migrationMetaHolders = new HashMap<String, MigrationMetaHolder>();
        for (Row versionRow : versionRows) {
            migrationVersions.add(MigrationVersion.fromVersion(versionRow.getString("version")));
            migrationMetaHolders.put(versionRow.getString("version"), new MigrationMetaHolder(versionRow.getInt("version_rank")));
        }
        Collections.sort(migrationVersions);
        BatchStatement batchStatement = new BatchStatement();
        PreparedStatement preparedStatement = this.cachePs.prepare("UPDATE " + this.keyspace.getName() + "." + this.tableName + " SET version_rank = ?" + " WHERE version = ?;");
        for (int i = 0; i < migrationVersions.size(); ++i) {
            if (version.compareTo((MigrationVersion)migrationVersions.get(i)) >= 0) continue;
            for (int z = i; z < migrationVersions.size(); ++z) {
                String migrationVersionStr = ((MigrationVersion)migrationVersions.get(z)).getVersion();
                batchStatement.add(preparedStatement.bind(((MigrationMetaHolder)migrationMetaHolders.get(migrationVersionStr)).getVersionRank() + 1, migrationVersionStr));
                batchStatement.setConsistencyLevel(ConsistencyLevel.ALL);
            }
            return i + 1;
        }
        this.session.execute(batchStatement);
        return migrationVersions.size() + 1;
    }

    class MigrationMetaHolder {
        private int versionRank;

        public MigrationMetaHolder(int versionRank) {
            this.versionRank = versionRank;
        }

        public int getVersionRank() {
            return this.versionRank;
        }
    }
}

