/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration.config;

import com.contrastsecurity.cassandra.migration.info.MigrationVersion;
import com.contrastsecurity.cassandra.migration.utils.StringUtils;

public class MigrationConfigs {
    private String encoding = "UTF-8";
    private String[] scriptsLocations = new String[]{"db/migration"};
    private boolean allowOutOfOrder = false;
    private MigrationVersion target = MigrationVersion.LATEST;

    public MigrationConfigs() {
        String allowOutOfOrderProp;
        String locationsProp;
        String targetVersionP;
        String scriptsEncodingP = System.getProperty(MigrationProperty.SCRIPTS_ENCODING.getName());
        if (null != scriptsEncodingP && scriptsEncodingP.trim().length() != 0) {
            this.encoding = scriptsEncodingP;
        }
        if (null != (targetVersionP = System.getProperty(MigrationProperty.TARGET_VERSION.getName())) && targetVersionP.trim().length() != 0) {
            this.setTargetAsString(targetVersionP);
        }
        if ((locationsProp = System.getProperty(MigrationProperty.SCRIPTS_LOCATIONS.getName())) != null && locationsProp.trim().length() != 0) {
            this.scriptsLocations = StringUtils.tokenizeToStringArray(locationsProp, ",");
        }
        if ((allowOutOfOrderProp = System.getProperty(MigrationProperty.ALLOW_OUTOFORDER.getName())) != null && allowOutOfOrderProp.trim().length() != 0) {
            this.setAllowOutOfOrder(allowOutOfOrderProp);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String[] getScriptsLocations() {
        return this.scriptsLocations;
    }

    public void setScriptsLocations(String[] scriptsLocations) {
        this.scriptsLocations = scriptsLocations;
    }

    public boolean isAllowOutOfOrder() {
        return this.allowOutOfOrder;
    }

    public void setAllowOutOfOrder(String allowOutOfOrder) {
        this.allowOutOfOrder = Boolean.parseBoolean(allowOutOfOrder);
    }

    public void setAllowOutOfOrder(boolean allowOutOfOrder) {
        this.allowOutOfOrder = allowOutOfOrder;
    }

    public MigrationVersion getTarget() {
        return this.target;
    }

    public void setTargetAsString(String target) {
        this.target = MigrationVersion.fromVersion(target);
    }

    public static enum MigrationProperty {
        SCRIPTS_ENCODING("cassandra.migration.scripts.encoding", "Encoding for CQL scripts"),
        SCRIPTS_LOCATIONS("cassandra.migration.scripts.locations", "Locations of the migration scripts in CSV format"),
        ALLOW_OUTOFORDER("cassandra.migration.scripts.allowoutoforder", "Allow out of order migration"),
        TARGET_VERSION("cassandra.migration.version.target", "The target version. Migrations with a higher version number will be ignored.");

        private String name;
        private String description;

        private MigrationProperty(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

