/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration;

import com.contrastsecurity.cassandra.migration.CassandraMigration;
import com.contrastsecurity.cassandra.migration.config.Keyspace;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.contrastsecurity.cassandra.migration.logging.console.ConsoleLog;
import com.contrastsecurity.cassandra.migration.logging.console.ConsoleLogCreator;
import java.util.ArrayList;
import java.util.List;

public class CommandLine {
    private static Log LOG;

    public static void main(String[] args) {
        ConsoleLog.Level logLevel = CommandLine.getLogLevel(args);
        CommandLine.initLogging(logLevel);
        List<String> operations = CommandLine.determineOperations(args);
        if (operations.isEmpty()) {
            CommandLine.printUsage();
            return;
        }
        CassandraMigration cm = new CassandraMigration();
        Keyspace ks = new Keyspace();
        cm.setKeyspace(ks);
        cm.migrate();
    }

    private static List<String> determineOperations(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }

    static void initLogging(ConsoleLog.Level level) {
        LogFactory.setLogCreator(new ConsoleLogCreator(level));
        LOG = LogFactory.getLog(CommandLine.class);
    }

    private static ConsoleLog.Level getLogLevel(String[] args) {
        for (String arg : args) {
            if ("-X".equals(arg)) {
                return ConsoleLog.Level.DEBUG;
            }
            if (!"-q".equals(arg)) continue;
            return ConsoleLog.Level.WARN;
        }
        return ConsoleLog.Level.INFO;
    }

    private static void printUsage() {
        LOG.info("********");
        LOG.info("* Usage");
        LOG.info("********");
        LOG.info("");
        LOG.info("cassandra-migration [options] command");
        LOG.info("");
        LOG.info("Commands");
        LOG.info("========");
        LOG.info("migrate  : Migrates the database");
        LOG.info("");
        LOG.info("Add -X to print debug output");
        LOG.info("Add -q to suppress all output, except for errors and warnings");
        LOG.info("");
    }
}

