/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.cassandra.migration;

import com.contrastsecurity.cassandra.migration.CassandraMigrationException;
import com.contrastsecurity.cassandra.migration.action.Initialize;
import com.contrastsecurity.cassandra.migration.action.Migrate;
import com.contrastsecurity.cassandra.migration.config.Keyspace;
import com.contrastsecurity.cassandra.migration.config.MigrationConfigs;
import com.contrastsecurity.cassandra.migration.config.ScriptsLocations;
import com.contrastsecurity.cassandra.migration.dao.SchemaVersionDAO;
import com.contrastsecurity.cassandra.migration.info.MigrationInfoService;
import com.contrastsecurity.cassandra.migration.info.MigrationVersion;
import com.contrastsecurity.cassandra.migration.logging.Log;
import com.contrastsecurity.cassandra.migration.logging.LogFactory;
import com.contrastsecurity.cassandra.migration.resolver.CompositeMigrationResolver;
import com.contrastsecurity.cassandra.migration.resolver.MigrationResolver;
import com.contrastsecurity.cassandra.migration.utils.VersionPrinter;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import java.util.List;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class CassandraMigration {
    private static final Log LOG = LogFactory.getLog(CassandraMigration.class);
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Keyspace keyspace = new Keyspace();
    private MigrationConfigs configs = new MigrationConfigs();

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    public MigrationConfigs getConfigs() {
        return this.configs;
    }

    private MigrationResolver createMigrationResolver() {
        return new CompositeMigrationResolver(this.classLoader, new ScriptsLocations(this.configs.getScriptsLocations()), this.configs.getEncoding(), new MigrationResolver[0]);
    }

    public int migrate() {
        return this.execute(new Action<Integer>(){

            @Override
            public Integer execute(Session session) {
                new Initialize().run(session, CassandraMigration.this.keyspace, MigrationVersion.CURRENT.getTable());
                MigrationResolver migrationResolver = CassandraMigration.this.createMigrationResolver();
                SchemaVersionDAO schemaVersionDAO = new SchemaVersionDAO(session, CassandraMigration.this.keyspace, MigrationVersion.CURRENT.getTable());
                Migrate migrate = new Migrate(migrationResolver, CassandraMigration.this.configs.getTarget(), schemaVersionDAO, session, CassandraMigration.this.keyspace.getCluster().getUsername(), CassandraMigration.this.configs.isAllowOutOfOrder());
                return migrate.run();
            }
        });
    }

    public MigrationInfoService info() {
        return this.execute(new Action<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(Session session) {
                MigrationResolver migrationResolver = CassandraMigration.this.createMigrationResolver();
                SchemaVersionDAO schemaVersionDAO = new SchemaVersionDAO(session, CassandraMigration.this.keyspace, MigrationVersion.CURRENT.getTable());
                MigrationInfoService migrationInfoService = new MigrationInfoService(migrationResolver, schemaVersionDAO, CassandraMigration.this.configs.getTarget(), false, true);
                migrationInfoService.refresh();
                return migrationInfoService;
            }
        });
    }

    public void baseline() {
        throw new NotImplementedException();
    }

    private String getConnectionInfo(Metadata metadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("Connected to cluster: ");
        sb.append(metadata.getClusterName());
        sb.append("\n");
        for (Host host : metadata.getAllHosts()) {
            sb.append("Data center: ");
            sb.append(host.getDatacenter());
            sb.append("; Host: ");
            sb.append(host.getAddress());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Action<T> action) {
        T result;
        VersionPrinter.printVersion(this.classLoader);
        Cluster cluster = null;
        Session session = null;
        try {
            if (null == this.keyspace) {
                throw new IllegalArgumentException("Unable to establish Cassandra session. Keyspace is not configured.");
            }
            if (null == this.keyspace.getCluster()) {
                throw new IllegalArgumentException("Unable to establish Cassandra session. Cluster is not configured.");
            }
            Cluster.Builder builder = new Cluster.Builder();
            builder.addContactPoints(this.keyspace.getCluster().getContactpoints()).withPort(this.keyspace.getCluster().getPort());
            if (null != this.keyspace.getCluster().getUsername() && !this.keyspace.getCluster().getUsername().trim().isEmpty()) {
                if (null != this.keyspace.getCluster().getPassword() && !this.keyspace.getCluster().getPassword().trim().isEmpty()) {
                    builder.withCredentials(this.keyspace.getCluster().getUsername(), this.keyspace.getCluster().getPassword());
                } else {
                    throw new IllegalArgumentException("Password must be provided with username.");
                }
            }
            cluster = builder.build();
            Metadata metadata = cluster.getMetadata();
            LOG.info(this.getConnectionInfo(metadata));
            session = cluster.newSession();
            if (null == this.keyspace.getName() || this.keyspace.getName().trim().length() == 0) {
                throw new IllegalArgumentException("Keyspace not specified.");
            }
            List<KeyspaceMetadata> keyspaces = metadata.getKeyspaces();
            boolean keyspaceExists = false;
            for (KeyspaceMetadata keyspaceMetadata : keyspaces) {
                if (!keyspaceMetadata.getName().equalsIgnoreCase(this.keyspace.getName())) continue;
                keyspaceExists = true;
            }
            if (!keyspaceExists) {
                throw new CassandraMigrationException("Keyspace: " + this.keyspace.getName() + " does not exist.");
            }
            session.execute("USE " + this.keyspace.getName());
            result = action.execute(session);
        }
        finally {
            if (null != session && !session.isClosed()) {
                try {
                    session.close();
                }
                catch (Exception e) {
                    LOG.warn("Error closing Cassandra session");
                }
            }
            if (null != cluster && !cluster.isClosed()) {
                try {
                    cluster.close();
                }
                catch (Exception e) {
                    LOG.warn("Error closing Cassandra cluster");
                }
            }
        }
        return result;
    }

    static interface Action<T> {
        public T execute(Session var1);
    }
}

