/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.log;

import jakarta.ws.rs.client.Invocation;
import org.slf4j.MDC;

public class AttributePassingUtils {
    public static final String TASK_ID_CONTEXT_ATTR = "task_id";
    public static final String RECORD_ID_CONTEXT_ATTR = "record_id";
    public static final String RECORD_DELETED_CONTEXT_ATTR = "deleted";

    private AttributePassingUtils() {
    }

    public static Invocation.Builder passLogContext(Invocation.Builder requestBuilder) {
        String taskId = MDC.get((String)TASK_ID_CONTEXT_ATTR);
        String recordId = MDC.get((String)RECORD_ID_CONTEXT_ATTR);
        return requestBuilder.header(TASK_ID_CONTEXT_ATTR, (Object)taskId).header(RECORD_ID_CONTEXT_ATTR, (Object)recordId);
    }

    public static void runWithTaskIdLogAttr(long taskId, Runnable runnable) {
        try {
            MDC.put((String)TASK_ID_CONTEXT_ATTR, (String)String.valueOf(taskId));
            runnable.run();
        }
        finally {
            MDC.remove((String)TASK_ID_CONTEXT_ATTR);
        }
    }
}

