/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.persisted;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.mcs.driver.DataSetIterator;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.utils.CloudIdReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderRemover {
    static final Logger LOGGER = LoggerFactory.getLogger(ProviderRemover.class);
    private static final int FETCH_LIMIT = 1000;
    private final String url;
    private final String username;
    private final String password;
    private final boolean testMode;
    private static final int RECORD_CONNECT_TIMEOUT = 300000;
    private static final int RECORD_READ_TIMEOUT = 600000;
    private static final int DATASET_CONNECT_TIMEOUT = 300000;
    private static final int DATASET_READ_TIMEOUT = 600000;

    public ProviderRemover(String url, String username, String password, boolean testMode) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.testMode = testMode;
    }

    public void removeAllRecords(List<String> providers) throws CloudException {
        for (String providerId : providers) {
            this.removeRecordsForProvider(providerId);
        }
    }

    public void removeRecordsFromFile(String filename) throws IOException {
        try (UISClient uisClient = new UISClient(this.url, this.username, this.password);){
            List<String> cloudIds;
            CloudIdReader reader = new CloudIdReader(filename);
            int counter = 0;
            do {
                cloudIds = reader.getNextCloudId(1000);
                counter = this.removeRecords(uisClient, cloudIds, counter);
            } while (cloudIds.size() == 1000);
            reader.close();
        }
    }

    public void removeRecordsForProvider(String providerId) throws CloudException {
        try (UISClient uisClient = new UISClient(this.url, this.username, this.password);){
            String startRecordId = "";
            Object records = null;
            int counter = 0;
            do {
                if (records != null && records.getResults() != null && !records.getResults().isEmpty()) {
                    startRecordId = records.getNextSlice();
                    counter = this.removeRecords(uisClient, records.getResults(), counter);
                    continue;
                }
                startRecordId = null;
            } while (startRecordId != null);
            LOGGER.info("Total processed records for provider '{}' : {}}", (Object)providerId, (Object)counter);
        }
    }

    private int removeRecords(UISClient uisClient, List<?> records, int counter) {
        Object cloudObject;
        String id;
        RecordServiceClient recordServiceClient = new RecordServiceClient(this.url, null, this.username, this.password, 300000, 600000);
        HashSet<String> removedRecords = new HashSet<String>();
        Iterator<?> iterator = records.iterator();
        while (iterator.hasNext() && (id = (cloudObject = iterator.next()) instanceof CloudId ? ((CloudId)cloudObject).getId() : (String)cloudObject) != null) {
            LOGGER.info("[{}] Remove record '{}'...", (Object)(++counter), (Object)id);
            if (this.testMode || removedRecords.contains(id)) continue;
            try {
                block5: {
                    try {
                        recordServiceClient.deleteRecord(id);
                    }
                    catch (MCSException mcsException) {
                        if (mcsException.getMessage().indexOf("No representation found for given cloudId") != -1 || mcsException.getMessage().indexOf("There is no record with provided global id") != -1) break block5;
                        throw mcsException;
                    }
                }
                uisClient.deleteCloudId(id);
                LOGGER.info("Record with cloudId = '{}' removed", (Object)id);
                removedRecords.add(id);
            }
            catch (CloudException | DriverException | MCSException serviceException) {
                LOGGER.error(String.format("Error while removing record '%s' : %s", id, serviceException.getMessage()));
            }
        }
        return counter;
    }

    public void removeAllDatasets(List<String> providers) {
        for (String providerId : providers) {
            this.removeDatasetsForProvider(providerId);
        }
    }

    public void removeDatasetsForProvider(String providerId) {
        int counter = 0;
        DataSetServiceClient dataSetServiceClient = new DataSetServiceClient(this.url, null, this.username, this.password, 300000, 600000);
        DataSetIterator dataSetIterator = dataSetServiceClient.getDataSetIteratorForProvider(providerId);
        while (dataSetIterator.hasNext()) {
            DataSet dataSet = dataSetIterator.next();
            LOGGER.info("[{}] Remove dataset '{}'...", (Object)counter, (Object)dataSet.getId());
            if (!this.testMode) {
                try {
                    dataSetServiceClient.deleteDataSet(providerId, dataSet.getId());
                    LOGGER.info("Dataset '{}' removed", (Object)dataSet.getId());
                }
                catch (MCSException mcsException) {
                    LOGGER.error(String.format("Error while removing dataset '%s' : %s", dataSet.getId(), mcsException.getMessage()));
                }
            }
            ++counter;
        }
        LOGGER.info("Total processed datasets for provider '{}' : {}", (Object)providerId, (Object)counter);
    }
}

