/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.executer;

import eu.europeana.cloud.api.Remover;
import eu.europeana.cloud.readers.CommaSeparatorReaderImpl;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoverInvoker {
    private final Remover remover;
    static final Logger LOGGER = LoggerFactory.getLogger(RemoverInvoker.class);

    public RemoverInvoker(Remover remover) {
        this.remover = remover;
    }

    public void executeInvokerForSingleTask(long taskId, boolean shouldRemoveErrors) {
        this.remover.removeNotifications(taskId);
        LOGGER.info("Logs for task Id:{} were removed successfully", (Object)taskId);
        LOGGER.info("Removing statistics for:{} was started. This step could take times depending on the size of the task", (Object)taskId);
        this.remover.removeStatistics(taskId);
        LOGGER.info("Statistics for task Id:{} were removed successfully", (Object)taskId);
        if (shouldRemoveErrors) {
            this.remover.removeErrorReports(taskId);
            LOGGER.info("Error reports for task Id:{} were removed successfully", (Object)taskId);
        }
    }

    public void executeInvokerForListOfTasks(String filePath, boolean shouldRemoveErrors) throws IOException {
        CommaSeparatorReaderImpl reader = new CommaSeparatorReaderImpl();
        List<String> taskIds = reader.getTaskIds(filePath);
        for (String taskId : taskIds) {
            this.executeInvokerForSingleTask(Long.valueOf(taskId), shouldRemoveErrors);
        }
    }
}

