/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.UrlUtils;

public class DefaultRedirectStrategy
implements RedirectStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean contextRelative;

    @Override
    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        String redirectUrl = this.calculateRedirectUrl(request.getContextPath(), url);
        redirectUrl = response.encodeRedirectURL(redirectUrl);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Redirecting to '" + redirectUrl + "'");
        }
        response.sendRedirect(redirectUrl);
    }

    protected String calculateRedirectUrl(String contextPath, String url) {
        if (!UrlUtils.isAbsoluteUrl(url)) {
            if (this.isContextRelative()) {
                return url;
            }
            return contextPath + url;
        }
        if (!this.isContextRelative()) {
            return url;
        }
        if (!url.contains(contextPath)) {
            return "";
        }
        url = url.substring(url.lastIndexOf("://") + 3);
        if ((url = url.substring(url.indexOf(contextPath) + contextPath.length())).length() > 1 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    public void setContextRelative(boolean useRelativeContext) {
        this.contextRelative = useRelativeContext;
    }

    protected boolean isContextRelative() {
        return this.contextRelative;
    }
}

