/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.subscription;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.subscription.TopicFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedTopicFilter
implements TopicFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NamedTopicFilter.class);
    private final Set<String> topics;

    public NamedTopicFilter(Set<String> topics) {
        this.topics = Collections.unmodifiableSet(topics);
    }

    public NamedTopicFilter(String ... topics) {
        this(new HashSet<String>(Arrays.asList(topics)));
    }

    @Override
    public Set<TopicPartition> getAllSubscribedPartitions(Consumer<?, ?> consumer) {
        HashSet<TopicPartition> allPartitions = new HashSet<TopicPartition>();
        for (String topic : this.topics) {
            List<PartitionInfo> partitionInfoList = consumer.partitionsFor(topic);
            if (partitionInfoList != null) {
                for (PartitionInfo partitionInfo : partitionInfoList) {
                    allPartitions.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
                }
                continue;
            }
            LOG.warn("Topic {} not found, skipping addition of the topic", (Object)topic);
        }
        return allPartitions;
    }

    @Override
    public String getTopicsString() {
        return String.join((CharSequence)",", this.topics);
    }
}

