/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ConvertedRecords;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.RecordsProcessingStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public abstract class AbstractRecords
implements Records {
    private final Iterable<Record> records = new Iterable<Record>(){

        @Override
        public Iterator<Record> iterator() {
            return AbstractRecords.this.recordsIterator();
        }
    };

    @Override
    public boolean hasMatchingMagic(byte magic) {
        for (RecordBatch recordBatch : this.batches()) {
            if (recordBatch.magic() == magic) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasCompatibleMagic(byte magic) {
        for (RecordBatch recordBatch : this.batches()) {
            if (recordBatch.magic() <= magic) continue;
            return false;
        }
        return true;
    }

    protected ConvertedRecords<MemoryRecords> downConvert(Iterable<? extends RecordBatch> batches, byte toMagic, long firstOffset, Time time) {
        ArrayList<RecordBatchAndRecords> recordBatchAndRecordsList = new ArrayList<RecordBatchAndRecords>();
        int totalSizeEstimate = 0;
        long startNanos = time.nanoseconds();
        for (RecordBatch recordBatch : batches) {
            if (toMagic < 2 && recordBatch.isControlBatch()) continue;
            if (recordBatch.magic() <= toMagic) {
                totalSizeEstimate += recordBatch.sizeInBytes();
                recordBatchAndRecordsList.add(new RecordBatchAndRecords(recordBatch, null, null));
                continue;
            }
            ArrayList<Record> records = new ArrayList<Record>();
            for (Object record : recordBatch) {
                if (toMagic <= 1 && !recordBatch.isCompressed() && record.offset() < firstOffset) continue;
                records.add((Record)record);
            }
            if (records.isEmpty()) continue;
            long baseOffset = recordBatch.magic() >= 2 && toMagic >= 2 ? recordBatch.baseOffset() : ((Record)records.get(0)).offset();
            totalSizeEstimate += AbstractRecords.estimateSizeInBytes(toMagic, baseOffset, recordBatch.compressionType(), records);
            recordBatchAndRecordsList.add(new RecordBatchAndRecords(recordBatch, records, baseOffset));
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalSizeEstimate);
        long l = 0L;
        int numRecordsConverted = 0;
        for (RecordBatchAndRecords recordBatchAndRecords : recordBatchAndRecordsList) {
            l += (long)recordBatchAndRecords.batch.sizeInBytes();
            if (recordBatchAndRecords.batch.magic() <= toMagic) {
                recordBatchAndRecords.batch.writeTo(buffer);
                continue;
            }
            MemoryRecordsBuilder builder = this.convertRecordBatch(toMagic, buffer, recordBatchAndRecords);
            buffer = builder.buffer();
            l += (long)builder.uncompressedBytesWritten();
            numRecordsConverted += builder.numRecords();
        }
        buffer.flip();
        RecordsProcessingStats stats = new RecordsProcessingStats(l, numRecordsConverted, time.nanoseconds() - startNanos);
        return new ConvertedRecords<MemoryRecords>(MemoryRecords.readableRecords(buffer), stats);
    }

    private MemoryRecordsBuilder convertRecordBatch(byte magic, ByteBuffer buffer, RecordBatchAndRecords recordBatchAndRecords) {
        RecordBatch batch = recordBatchAndRecords.batch;
        TimestampType timestampType = batch.timestampType();
        long logAppendTime = timestampType == TimestampType.LOG_APPEND_TIME ? batch.maxTimestamp() : -1L;
        MemoryRecordsBuilder builder = MemoryRecords.builder(buffer, magic, batch.compressionType(), timestampType, recordBatchAndRecords.baseOffset, logAppendTime);
        for (Record record : recordBatchAndRecords.records) {
            if (magic > 1) {
                builder.append(record);
                continue;
            }
            builder.appendWithOffset(record.offset(), record.timestamp(), record.key(), record.value());
        }
        builder.close();
        return builder;
    }

    @Override
    public Iterable<Record> records() {
        return this.records;
    }

    private Iterator<Record> recordsIterator() {
        return new AbstractIterator<Record>(){
            private final Iterator<? extends RecordBatch> batches;
            private Iterator<Record> records;
            {
                this.batches = AbstractRecords.this.batches().iterator();
            }

            @Override
            protected Record makeNext() {
                if (this.records != null && this.records.hasNext()) {
                    return this.records.next();
                }
                if (this.batches.hasNext()) {
                    this.records = this.batches.next().iterator();
                    return this.makeNext();
                }
                return (Record)this.allDone();
            }
        };
    }

    public static int estimateSizeInBytes(byte magic, long baseOffset, CompressionType compressionType, Iterable<Record> records) {
        int size = 0;
        if (magic <= 1) {
            for (Record record : records) {
                size += 12 + LegacyRecord.recordSize(magic, record.key(), record.value());
            }
        } else {
            size = DefaultRecordBatch.sizeInBytes(baseOffset, records);
        }
        return AbstractRecords.estimateCompressedSizeInBytes(size, compressionType);
    }

    public static int estimateSizeInBytes(byte magic, CompressionType compressionType, Iterable<SimpleRecord> records) {
        int size = 0;
        if (magic <= 1) {
            for (SimpleRecord record : records) {
                size += 12 + LegacyRecord.recordSize(magic, record.key(), record.value());
            }
        } else {
            size = DefaultRecordBatch.sizeInBytes(records);
        }
        return AbstractRecords.estimateCompressedSizeInBytes(size, compressionType);
    }

    private static int estimateCompressedSizeInBytes(int size, CompressionType compressionType) {
        return compressionType == CompressionType.NONE ? size : Math.min(Math.max(size / 2, 1024), 65536);
    }

    public static int estimateSizeInBytesUpperBound(byte magic, CompressionType compressionType, byte[] key, byte[] value, Header[] headers) {
        return AbstractRecords.estimateSizeInBytesUpperBound(magic, compressionType, Utils.wrapNullable(key), Utils.wrapNullable(value), headers);
    }

    public static int estimateSizeInBytesUpperBound(byte magic, CompressionType compressionType, ByteBuffer key, ByteBuffer value, Header[] headers) {
        if (magic >= 2) {
            return DefaultRecordBatch.estimateBatchSizeUpperBound(key, value, headers);
        }
        if (compressionType != CompressionType.NONE) {
            return 12 + LegacyRecord.recordOverhead(magic) + LegacyRecord.recordSize(magic, key, value);
        }
        return 12 + LegacyRecord.recordSize(magic, key, value);
    }

    public static int recordBatchHeaderSizeInBytes(byte magic, CompressionType compressionType) {
        if (magic > 1) {
            return 61;
        }
        if (compressionType != CompressionType.NONE) {
            return 12 + LegacyRecord.recordOverhead(magic);
        }
        return 0;
    }

    private static class RecordBatchAndRecords {
        private final RecordBatch batch;
        private final List<Record> records;
        private final Long baseOffset;

        private RecordBatchAndRecords(RecordBatch batch, List<Record> records, Long baseOffset) {
            this.batch = batch;
            this.records = records;
            this.baseOffset = baseOffset;
        }
    }
}

