/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import java.util.Map;
import org.apache.storm.policy.IWaitStrategy;

public class FastCancelingSpoutWaitStrategy
implements IWaitStrategy {
    private long sleepMs;
    private int sleepEveryNIdleIterations;

    public void prepare(Map<String, Object> config, IWaitStrategy.WaitSituation waitSituation) {
        this.sleepMs = ((Number)config.get("SPOUT_SLEEP_MS")).longValue();
        this.sleepEveryNIdleIterations = ((Number)config.get("SPOUT_SLEEP_EVERY_N_IDLE_ITERATIONS")).intValue();
    }

    public int idle(int idleCounter) throws InterruptedException {
        if (++idleCounter % this.sleepEveryNIdleIterations == 0) {
            Thread.sleep(this.sleepMs);
        }
        return idleCounter;
    }
}

